/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.FedoraResource;
import org.fcrepo.utils.FedoraTypesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedoraObject
extends FedoraResource {
    static final Logger logger = LoggerFactory.getLogger(FedoraObject.class);

    public FedoraObject(Node node) {
        super(node);
        this.mixinTypeSpecificCrap();
    }

    public FedoraObject(Session session, String string, String string2) throws RepositoryException {
        super(session, string, string2);
        this.mixinTypeSpecificCrap();
    }

    public FedoraObject(Session session, String string) throws RepositoryException {
        this(session, string, "nt:folder");
    }

    private void mixinTypeSpecificCrap() {
        try {
            if (this.node.isNew() || !FedoraObject.hasMixin(this.node)) {
                logger.debug("Setting {} properties on a {} node {}...", new Object[]{"fedora:object", "nt:folder", this.node.getPath()});
                this.node.addMixin("fedora:object");
            }
        }
        catch (RepositoryException repositoryException) {
            logger.warn("Could not decorate {} with {} properties: {} ", new Object[]{"jcr:content", "fedora:object", repositoryException});
        }
    }

    public String getName() throws RepositoryException {
        return this.node.getName();
    }

    public static boolean hasMixin(Node node) throws RepositoryException {
        return FedoraTypesUtils.isFedoraObject.apply((Object)node);
    }
}

