/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo;

import com.google.common.base.Function;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.update.UpdateAction;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.VersionHistory;
import org.fcrepo.rdf.GraphSubjects;
import org.fcrepo.rdf.impl.DefaultGraphSubjects;
import org.fcrepo.services.ServiceHelpers;
import org.fcrepo.utils.FedoraJcrTypes;
import org.fcrepo.utils.FedoraTypesUtils;
import org.fcrepo.utils.JcrPropertyStatementListener;
import org.fcrepo.utils.JcrRdfTools;
import org.modeshape.common.collection.Problems;
import org.modeshape.jcr.api.JcrTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedoraResource
extends JcrTools
implements FedoraJcrTypes {
    private static final Logger LOGGER = LoggerFactory.getLogger(FedoraResource.class);
    public static final GraphSubjects DEFAULT_SUBJECT_FACTORY = new DefaultGraphSubjects();
    protected Node node;
    private JcrPropertyStatementListener listener;

    public FedoraResource() {
        this.node = null;
    }

    public FedoraResource(Node node) {
        super(false);
        this.node = node;
    }

    public FedoraResource(Session session, String string, String string2) throws RepositoryException {
        super(false);
        this.node = this.findOrCreateNode(session, string, "nt:folder", string2);
        if (!FedoraResource.hasMixin(this.node)) {
            this.node.addMixin("fedora:resource");
        }
        if (this.node.isNew()) {
            if (this.node.getSession() != null) {
                this.node.setProperty("jcr:createdby", this.node.getSession().getUserID());
            }
            this.node.setProperty("jcr:lastModified", Calendar.getInstance());
        }
    }

    public static boolean hasMixin(Node node) throws RepositoryException {
        return FedoraTypesUtils.isFedoraResource.apply((Object)node);
    }

    public boolean hasContent() throws RepositoryException {
        return this.node.hasNode("jcr:content");
    }

    public Node getNode() {
        return this.node;
    }

    public String getPath() throws RepositoryException {
        return this.node.getPath();
    }

    public Date getCreatedDate() throws RepositoryException {
        if (this.node.hasProperty("jcr:created")) {
            return new Date(this.node.getProperty("jcr:created").getDate().getTimeInMillis());
        }
        LOGGER.info("Node {} does not have a createdDate", (Object)this.node);
        return null;
    }

    public Date getLastModifiedDate() throws RepositoryException {
        if (this.node.hasProperty("jcr:lastModified")) {
            return new Date(this.node.getProperty("jcr:lastModified").getDate().getTimeInMillis());
        }
        LOGGER.info("Could not get last modified date property for node {}", (Object)this.node);
        Date date = this.getCreatedDate();
        if (date != null) {
            LOGGER.info("Using created date for last modified date for node {}", (Object)this.node);
            return date;
        }
        return null;
    }

    public long getSize() throws RepositoryException {
        return ServiceHelpers.getObjectSize((Node)this.node);
    }

    public Collection<String> getModels() throws RepositoryException {
        return FedoraTypesUtils.map((Object[])this.node.getMixinNodeTypes(), (Function)FedoraTypesUtils.nodetype2name);
    }

    public Problems getDatasetProblems() throws RepositoryException {
        if (this.listener != null) {
            return this.listener.getProblems();
        }
        return null;
    }

    public void updatePropertiesDataset(GraphSubjects graphSubjects, String string) throws RepositoryException {
        Dataset dataset = this.getPropertiesDataset(graphSubjects, 0L, 0);
        UpdateAction.parseExecute((String)string, (Dataset)dataset);
    }

    public void updatePropertiesDataset(String string) throws RepositoryException {
        this.updatePropertiesDataset(DEFAULT_SUBJECT_FACTORY, string);
    }

    public Dataset getPropertiesDataset(GraphSubjects graphSubjects, long l, int n) throws RepositoryException {
        Model model = JcrRdfTools.getJcrPropertiesModel((GraphSubjects)graphSubjects, (Node)this.node);
        Model model2 = JcrRdfTools.getJcrTreeModel((GraphSubjects)graphSubjects, (Node)this.node, (long)l, (int)n);
        this.listener = new JcrPropertyStatementListener(graphSubjects, this.node.getSession());
        model.register((ModelChangedListener)this.listener);
        model2.register((ModelChangedListener)this.listener);
        Dataset dataset = DatasetFactory.create((Model)model);
        dataset.addNamedModel("tree", model2);
        String string = JcrRdfTools.getGraphSubject((GraphSubjects)graphSubjects, (Node)this.node).getURI();
        Context context = dataset.getContext();
        context.set(Symbol.create((String)"uri"), (Object)string);
        return dataset;
    }

    public Dataset getPropertiesDataset(GraphSubjects graphSubjects) throws RepositoryException {
        return this.getPropertiesDataset(graphSubjects, 0L, -1);
    }

    public Dataset getPropertiesDataset() throws RepositoryException {
        return this.getPropertiesDataset(DEFAULT_SUBJECT_FACTORY);
    }

    public Dataset getVersionDataset(GraphSubjects graphSubjects) throws RepositoryException {
        Model model = JcrRdfTools.getJcrVersionsModel((GraphSubjects)graphSubjects, (Node)this.node);
        Dataset dataset = DatasetFactory.create((Model)model);
        String string = JcrRdfTools.getGraphSubject((GraphSubjects)graphSubjects, (Node)this.node).getURI();
        Context context = dataset.getContext();
        context.set(Symbol.create((String)"uri"), (Object)string);
        return dataset;
    }

    public Dataset getVersionDataset() throws RepositoryException {
        return this.getVersionDataset(DEFAULT_SUBJECT_FACTORY);
    }

    public void addVersionLabel(String string) throws RepositoryException {
        VersionHistory versionHistory = FedoraTypesUtils.getVersionHistory((Node)this.node);
        versionHistory.addVersionLabel(FedoraTypesUtils.getBaseVersion((Node)this.node).getName(), string, true);
    }

    public boolean isNew() {
        return this.node.isNew();
    }
}

