/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo;

import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.TxAwareSession;

public class Transaction {
    public static final long DEFAULT_TIMEOUT = 180000L;
    public static final String TIMEOUT_SYSTEM_PROPERTY = "fcrepo4.tx.timeout";
    private final Session session;
    private final String id;
    private final Date created;
    private Calendar expires;
    private State state = State.NEW;

    public Transaction(Session session) {
        this.session = session;
        this.created = new Date();
        this.id = UUID.randomUUID().toString();
        this.expires = Calendar.getInstance();
        this.updateExpiryDate();
    }

    public Session getSession() {
        this.updateExpiryDate();
        return TxAwareSession.newInstance(this.session, this.id);
    }

    public Date getCreated() {
        return this.created;
    }

    public String getId() {
        return this.id;
    }

    public State getState() throws RepositoryException {
        if (this.session != null && this.session.hasPendingChanges()) {
            return State.DIRTY;
        }
        return this.state;
    }

    public Date getExpires() {
        return this.expires.getTime();
    }

    public void commit() throws RepositoryException {
        this.session.save();
        this.state = State.COMMITED;
        this.expire();
    }

    public void expire() throws RepositoryException {
        this.session.logout();
        this.expires.setTimeInMillis(System.currentTimeMillis());
    }

    public void rollback() throws RepositoryException {
        this.state = State.ROLLED_BACK;
        this.session.refresh(false);
        this.expire();
    }

    public void updateExpiryDate() {
        long l = System.getProperty(TIMEOUT_SYSTEM_PROPERTY) != null ? Long.parseLong(System.getProperty(TIMEOUT_SYSTEM_PROPERTY)) : 180000L;
        this.expires.setTimeInMillis(System.currentTimeMillis() + l);
    }

    public static enum State {
        DIRTY,
        NEW,
        COMMITED,
        ROLLED_BACK;

    }
}

