/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jcr.Session;
import org.fcrepo.TxSession;

public class TxAwareSession
implements InvocationHandler {
    private final String txId;
    private Session session;

    public TxAwareSession(Session session, String string) {
        this.session = session;
        this.txId = string;
    }

    public static Session newInstance(Session session, String string) {
        return (Session)Proxy.newProxyInstance(session.getClass().getClassLoader(), new Class[]{TxSession.class}, (InvocationHandler)new TxAwareSession(session, string));
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if (method.getName().equals("logout") || method.getName().equals("save")) {
            return null;
        }
        if (method.getName().equals("getTxId")) {
            return this.txId;
        }
        if (method.getName().equals("impersonate")) {
            return TxAwareSession.newInstance((Session)method.invoke((Object)this.session, objectArray), this.txId);
        }
        return method.invoke((Object)this.session, objectArray);
    }
}

