/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.api.rdf;

import com.google.common.collect.ImmutableBiMap;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.net.URI;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.TxSession;
import org.fcrepo.rdf.GraphSubjects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpGraphSubjects
implements GraphSubjects {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpGraphSubjects.class);
    private final UriBuilder nodesBuilder;
    private final String basePath;
    private final int pathIx;
    private final Session session;

    public HttpGraphSubjects(Class<?> clazz, UriInfo uriInfo, Session session) {
        this.nodesBuilder = uriInfo.getBaseUriBuilder().path(clazz);
        String string = this.nodesBuilder.build(new Object[]{""}).toString();
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        this.basePath = string;
        this.pathIx = string.length() - 1;
        LOGGER.debug("Resolving graph subjects to a base URI of \"{}\"", (Object)string);
        this.session = session;
    }

    public HttpGraphSubjects(Class<?> clazz, UriInfo uriInfo) {
        this(clazz, uriInfo, null);
    }

    public Resource getGraphSubject(String string) throws RepositoryException {
        URI uRI = this.nodesBuilder.buildFromMap(HttpGraphSubjects.getPathMap(this.session, string));
        LOGGER.debug("Translated path {} into RDF subject {}", (Object)string, (Object)uRI);
        return ResourceFactory.createResource((String)uRI.toString());
    }

    public Resource getGraphSubject(Node node) throws RepositoryException {
        URI uRI = this.nodesBuilder.buildFromMap(HttpGraphSubjects.getPathMap(this.session, node));
        LOGGER.debug("Translated node {} into RDF subject {}", (Object)node, (Object)uRI);
        return ResourceFactory.createResource((String)uRI.toString());
    }

    public Node getNodeFromGraphSubject(Session session, Resource resource) throws RepositoryException {
        Node node;
        Node node2;
        if (!this.isFedoraGraphSubject(resource)) {
            LOGGER.debug("RDF resource {} was not a URI resource with our expected basePath {}, aborting.", (Object)resource, (Object)this.basePath);
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : node2 = resource.getURI().substring(this.pathIx).split("/")) {
            String string2;
            if (string.startsWith("tx:")) {
                string2 = string.substring("tx:".length());
                if (session instanceof TxSession && ((TxSession)session).getTxId().equals(string2)) continue;
                throw new RepositoryException("Subject is not in this transaction");
            }
            if (string.startsWith("workspace:")) {
                string2 = string.substring("workspace:".length());
                if (session.getWorkspace().getName().equals(string2)) continue;
                throw new RepositoryException("Subject is not in this workspace");
            }
            if (string.isEmpty()) continue;
            stringBuilder.append("/");
            stringBuilder.append(string);
        }
        String string = stringBuilder.toString();
        if (string.endsWith("fcr:content")) {
            node = session.getNode(string.replace("fcr:content", "jcr:content"));
            LOGGER.trace("RDF resource {} is a fcr:content node, retrieving the corresponding JCR content node {}", (Object)resource, (Object)node);
        } else if (session.nodeExists(string)) {
            node = session.getNode(string);
            LOGGER.trace("RDF resource {} maps to JCR node {}", (Object)resource, (Object)node);
        } else {
            node = null;
            LOGGER.debug("RDF resource {} looks like a Fedora node, but when we checked was not in the repository", (Object)resource);
        }
        return node;
    }

    public boolean isFedoraGraphSubject(Resource resource) {
        return resource.isURIResource() && resource.getURI().startsWith(this.basePath);
    }

    private static Map<String, String> getPathMap(Session session, Node node) throws RepositoryException {
        return HttpGraphSubjects.getPathMap(session, node.getPath());
    }

    private static Map<String, String> getPathMap(Session session, String string) throws RepositoryException {
        String string2 = string.substring(1);
        if (string2.endsWith("jcr:content")) {
            string2 = string2.replace("jcr:content", "fcr:content");
        }
        if (session != null) {
            Workspace workspace = session.getWorkspace();
            if (session instanceof TxSession) {
                string2 = "tx:" + ((TxSession)session).getTxId() + "/" + string2;
            } else if (workspace != null && !workspace.getName().equals("default")) {
                string2 = "workspace:" + workspace.getName() + "/" + string2;
            }
        }
        return ImmutableBiMap.of((Object)"path", (Object)string2);
    }
}

