/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.api.rdf;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.FedoraResource;
import org.fcrepo.api.rdf.UriAwareResourceModelFactory;
import org.fcrepo.rdf.GraphSubjects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class HttpTripleUtil
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpTripleUtil.class);
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void addHttpComponentModelsForResource(Dataset dataset, FedoraResource fedoraResource, UriInfo uriInfo, GraphSubjects graphSubjects) throws RepositoryException {
        LOGGER.debug("Adding additional HTTP context triples to dataset");
        for (Map.Entry<String, UriAwareResourceModelFactory> entry : this.getUriAwareTripleFactories().entrySet()) {
            String string = entry.getKey();
            UriAwareResourceModelFactory uriAwareResourceModelFactory = entry.getValue();
            LOGGER.debug("Adding response information using {}", (Object)string);
            Model model = uriAwareResourceModelFactory.createModelForResource(fedoraResource, uriInfo, graphSubjects);
            dataset.addNamedModel(string, model);
        }
    }

    private Map<String, UriAwareResourceModelFactory> getUriAwareTripleFactories() {
        return this.applicationContext.getBeansOfType(UriAwareResourceModelFactory.class);
    }
}

