/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.exceptionhandlers;

import com.google.common.base.Throwables;
import javax.jcr.RepositoryException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class RepositoryExceptionMapper
implements ExceptionMapper<RepositoryException> {
    private final Logger LOGGER = LoggerFactory.getLogger(RepositoryExceptionMapper.class);
    Boolean showStackTrace = true;

    public Response toResponse(RepositoryException repositoryException) {
        this.LOGGER.warn("Caught repository exception: {}", (Throwable)repositoryException);
        return Response.serverError().entity((Object)(this.showStackTrace != false ? Throwables.getStackTraceAsString((Throwable)repositoryException) : null)).build();
    }
}

