/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.exceptionhandlers;

import com.google.common.base.Throwables;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.fcrepo.exception.TransactionMissingException;
import org.fcrepo.exceptionhandlers.TransactionMissingExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class WildcardExceptionMapper
implements ExceptionMapper<Exception> {
    Boolean showStackTrace = true;
    private static final Logger logger = LoggerFactory.getLogger(WildcardExceptionMapper.class);

    public Response toResponse(Exception exception) {
        if (WebApplicationException.class.isAssignableFrom(exception.getClass())) {
            logger.info("WebApplicationException intercepted by WildcardExceptionMapper: \n", (Throwable)exception);
            return ((WebApplicationException)exception).getResponse();
        }
        if (exception.getCause() instanceof TransactionMissingException) {
            return new TransactionMissingExceptionMapper().toResponse((TransactionMissingException)exception.getCause());
        }
        logger.error("Exception intercepted by WildcardExceptionMapper: \n", (Throwable)exception);
        return Response.serverError().entity((Object)(this.showStackTrace != false ? Throwables.getStackTraceAsString((Throwable)exception) : null)).build();
    }

    public void setShowStackTrace(Boolean bl) {
        this.showStackTrace = bl;
    }
}

