/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.responses;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.tools.generic.EscapeTool;
import org.apache.velocity.tools.generic.FieldTool;
import org.fcrepo.RdfLexicon;
import org.fcrepo.responses.HtmlTemplate;
import org.fcrepo.responses.RdfSerializationUtils;
import org.fcrepo.responses.ViewHelpers;
import org.fcrepo.session.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Provider
public class BaseHtmlProvider
implements MessageBodyWriter<Dataset> {
    @Autowired
    SessionFactory sessionFactory;
    @Context
    UriInfo uriInfo;
    private static EscapeTool escapeTool = new EscapeTool();
    protected VelocityEngine velocity = new VelocityEngine();
    public static final String templatesLocation = "/views";
    protected Map<String, Template> templatesMap;
    public static final String templateFilenameExtension = ".vsl";
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseHtmlProvider.class);
    public static final String velocityPropertiesLocation = "/velocity.properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    void init() throws IOException, RepositoryException {
        LOGGER.trace("Velocity engine initializing...");
        Properties properties = new Properties();
        URL uRL = this.getClass().getResource(velocityPropertiesLocation);
        LOGGER.debug("Using Velocity configuration from {}", (Object)uRL);
        try (InputStream inputStream = uRL.openStream();){
            properties.load(inputStream);
        }
        this.velocity.init(properties);
        LOGGER.trace("Velocity engine initialized.");
        LOGGER.trace("Assembling a map of node primary types -> templates...");
        inputStream = ImmutableMap.builder();
        var4_4 = this.sessionFactory.getSession();
        try {
            Template template;
            NodeTypeIterator nodeTypeIterator = var4_4.getWorkspace().getNodeTypeManager().getPrimaryNodeTypes();
            while (nodeTypeIterator.hasNext()) {
                String string = nodeTypeIterator.nextNodeType().getName();
                String string2 = "/views/" + string.replace(':', '-') + templateFilenameExtension;
                try {
                    template = this.velocity.getTemplate(string2);
                    template.setName(string2);
                    LOGGER.debug("Found template: {}", (Object)string2);
                    inputStream.put(string, template);
                    LOGGER.debug("which we will use for nodes with primary type: {}", (Object)string);
                }
                catch (ResourceNotFoundException resourceNotFoundException) {
                    LOGGER.debug("Didn't find template for nodes with primary type: {} in location: {}", (Object)string, (Object)string2);
                }
            }
            nodeTypeIterator = ImmutableList.of((Object)"search:results", (Object)"jcr:namespaces");
            for (String string2 : nodeTypeIterator) {
                template = this.velocity.getTemplate("/views/" + string2.replace(':', '-') + templateFilenameExtension);
                inputStream.put(string2, template);
            }
            this.templatesMap = inputStream.build();
        }
        finally {
            var4_4.logout();
        }
        LOGGER.trace("Assembled template map.");
        LOGGER.trace("HtmlProvider initialization complete.");
    }

    public void writeTo(Dataset dataset, Class<?> clazz, Type type, Annotation[] annotationArray, MediaType mediaType, MultivaluedMap<String, Object> multivaluedMap, OutputStream outputStream) throws IOException, WebApplicationException {
        LOGGER.debug("Writing an HTML response for: {}", (Object)dataset);
        LOGGER.trace("Attempting to discover our subject");
        Node node = RdfSerializationUtils.getDatasetSubject(dataset);
        multivaluedMap.put((Object)"Content-type", (Object)ImmutableList.of((Object)"text/html"));
        RdfSerializationUtils.setCachingHeaders(multivaluedMap, dataset);
        Template template = this.getTemplate(dataset, node, annotationArray);
        org.apache.velocity.context.Context context = this.getContext(dataset, node);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        template.merge(context, (Writer)outputStreamWriter);
        ((Writer)outputStreamWriter).flush();
    }

    protected org.apache.velocity.context.Context getContext(Dataset dataset, Node node) {
        FieldTool fieldTool = new FieldTool();
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("rdfLexicon", (Object)fieldTool.in(RdfLexicon.class));
        velocityContext.put("helpers", (Object)ViewHelpers.getInstance());
        velocityContext.put("esc", (Object)escapeTool);
        velocityContext.put("rdf", (Object)dataset.asDatasetGraph());
        Model model = RdfSerializationUtils.unifyDatasetModel(dataset);
        velocityContext.put("model", (Object)model);
        velocityContext.put("subjects", (Object)model.listSubjects());
        velocityContext.put("nodeany", (Object)Node.ANY);
        velocityContext.put("topic", (Object)node);
        velocityContext.put("uriInfo", (Object)this.uriInfo);
        return velocityContext;
    }

    private Template getTemplate(Dataset dataset, Node node, Annotation[] annotationArray) {
        Template template = null;
        for (Annotation annotation : annotationArray) {
            if (!(annotation instanceof HtmlTemplate)) continue;
            String string = ((HtmlTemplate)annotation).value();
            LOGGER.debug("Found an HtmlTemplate annotation {}", (Object)string);
            template = this.templatesMap.get(string);
            break;
        }
        if (template == null) {
            LOGGER.trace("Attempting to discover the primary type of the node for the resource in question...");
            String string = RdfSerializationUtils.getFirstValueForPredicate(dataset, node, RdfSerializationUtils.primaryTypePredicate);
            LOGGER.debug("Found primary node type: {}", (Object)string);
            template = this.templatesMap.get(string);
        }
        LOGGER.debug("Choosing template: {}", (Object)template.getName());
        return template;
    }

    public boolean isWriteable(Class<?> clazz, Type type, Annotation[] annotationArray, MediaType mediaType) {
        return mediaType.equals((Object)MediaType.TEXT_HTML_TYPE) && (Dataset.class.isAssignableFrom(clazz) || Dataset.class.isAssignableFrom(type.getClass()));
    }

    public long getSize(Dataset dataset, Class<?> clazz, Type type, Annotation[] annotationArray, MediaType mediaType) {
        return -1L;
    }
}

