/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.responses;

import com.google.common.collect.ImmutableList;
import com.hp.hpl.jena.query.Dataset;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.jena.riot.WebContent;
import org.fcrepo.responses.GraphStoreStreamingOutput;
import org.fcrepo.responses.RdfSerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Provider
@Component
public class RdfProvider
implements MessageBodyWriter<Dataset> {
    private static final Logger logger = LoggerFactory.getLogger(RdfProvider.class);

    public void writeTo(Dataset dataset, Class<?> clazz, Type type, Annotation[] annotationArray, MediaType mediaType, MultivaluedMap<String, Object> multivaluedMap, OutputStream outputStream) throws IOException, WebApplicationException {
        logger.debug("Writing a response for: {} with MIMEtype: {}", (Object)dataset, (Object)mediaType);
        multivaluedMap.put((Object)"Content-type", (Object)ImmutableList.of((Object)mediaType.toString()));
        RdfSerializationUtils.setCachingHeaders(multivaluedMap, dataset);
        new GraphStoreStreamingOutput(dataset, mediaType).write(outputStream);
    }

    public boolean isWriteable(Class<?> clazz, Type type, Annotation[] annotationArray, MediaType mediaType) {
        Boolean bl = WebContent.contentTypeToLang((String)mediaType.toString()) != null;
        return bl != false && (Dataset.class.isAssignableFrom(clazz) || Dataset.class.isAssignableFrom(type.getClass()));
    }

    public long getSize(Dataset dataset, Class<?> clazz, Type type, Annotation[] annotationArray, MediaType mediaType) {
        return -1L;
    }
}

