/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.responses;

import com.google.common.collect.ImmutableList;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Symbol;
import java.util.Iterator;
import javax.ws.rs.core.MultivaluedMap;
import org.fcrepo.utils.JcrRdfTools;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfSerializationUtils {
    private static final Logger logger = LoggerFactory.getLogger(RdfSerializationUtils.class);
    public static Node primaryTypePredicate = NodeFactory.createURI((String)(JcrRdfTools.getRDFNamespaceForJcrNamespace((String)"http://www.jcp.org/jcr/1.0") + "primaryType"));
    public static Node lastModifiedPredicate = NodeFactory.createURI((String)(JcrRdfTools.getRDFNamespaceForJcrNamespace((String)"http://www.jcp.org/jcr/1.0") + "lastModified"));
    public static DateTimeFormatter RFC2822DATEFORMAT = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss Z");

    static String getFirstValueForPredicate(Dataset dataset, Node node, Node node2) {
        Iterator iterator = dataset.asDatasetGraph().find(Node.ANY, node, node2, Node.ANY);
        if (iterator.hasNext()) {
            Quad quad = (Quad)iterator.next();
            logger.trace("Checking statement: {}", (Object)quad);
            return quad.asTriple().getObject().getLiteral().getLexicalForm();
        }
        logger.trace("No value found for predicate: {}", (Object)node2);
        return null;
    }

    static Node getDatasetSubject(Dataset dataset) {
        Context context = dataset.getContext();
        String string = context.getAsString(Symbol.create((String)"uri"));
        logger.debug("uri from context: {}", (Object)string);
        if (string != null) {
            return NodeFactory.createURI((String)string);
        }
        return null;
    }

    static void setCachingHeaders(MultivaluedMap<String, Object> multivaluedMap, Dataset dataset) {
        multivaluedMap.put((Object)"Cache-Control", (Object)ImmutableList.of((Object)"max-age=0"));
        multivaluedMap.put((Object)"Cache-Control", (Object)ImmutableList.of((Object)"must-revalidate"));
        logger.trace("Attempting to discover the last-modified date of the node for the resource in question...");
        Iterator iterator = dataset.asDatasetGraph().find(Node.ANY, RdfSerializationUtils.getDatasetSubject(dataset), lastModifiedPredicate, Node.ANY);
        if (!iterator.hasNext()) {
            return;
        }
        Object object = ((Quad)iterator.next()).getObject().getLiteralValue();
        if (!(object instanceof XSDDateTime)) {
            logger.debug("Found last-modified date, but it wasnot an XSDDateTime: {}", object);
            return;
        }
        XSDDateTime xSDDateTime = (XSDDateTime)object;
        logger.debug("Found last-modified date: {}", (Object)xSDDateTime);
        String string = RFC2822DATEFORMAT.print((ReadableInstant)new DateTime((Object)xSDDateTime.asCalendar()));
        multivaluedMap.put((Object)"Last-Modified", (Object)ImmutableList.of((Object)string));
    }

    static Model unifyDatasetModel(Dataset dataset) {
        Iterator iterator = dataset.listNames();
        Model model = ModelFactory.createDefaultModel();
        model = model.union(dataset.getDefaultModel());
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            logger.debug("Serializing model {}", (Object)string);
            model = model.union(dataset.getNamedModel(string));
        }
        model.setNsPrefixes(dataset.getDefaultModel().getNsPrefixMap());
        return model;
    }
}

