/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.responses;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.RdfLexicon;
import org.fcrepo.api.rdf.QuadOrdering;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewHelpers {
    private final Logger LOGGER = LoggerFactory.getLogger(ViewHelpers.class);
    private static ViewHelpers instance = null;

    protected ViewHelpers() {
    }

    public static ViewHelpers getInstance() {
        if (instance == null) {
            instance = new ViewHelpers();
        }
        return instance;
    }

    public Iterator<Quad> getObjects(DatasetGraph datasetGraph, Node node, Resource resource) {
        return datasetGraph.find(Node.ANY, node, resource.asNode(), Node.ANY);
    }

    public String getObjectTitle(DatasetGraph datasetGraph, Node node) {
        Property[] propertyArray;
        for (Property property : propertyArray = new Property[]{RdfLexicon.RDFS_LABEL, RdfLexicon.DC_TITLE}) {
            Iterator<Quad> iterator = this.getObjects(datasetGraph, node, (Resource)property);
            if (!iterator.hasNext()) continue;
            return iterator.next().getObject().getLiteralValue().toString();
        }
        if (node.isURI()) {
            return node.getURI();
        }
        if (node.isBlank()) {
            return node.getBlankNodeLabel();
        }
        return node.toString();
    }

    public String getObjectsAsString(DatasetGraph datasetGraph, Node node, Resource resource) {
        Iterator<Quad> iterator = this.getObjects(datasetGraph, node, resource);
        if (iterator.hasNext()) {
            Node node2 = iterator.next().getObject();
            if (node2.isLiteral()) {
                String string = node2.getLiteralValue().toString();
                if (string.isEmpty()) {
                    return "<empty>";
                }
                return string;
            }
            return "&lt;<a href=\"" + node2.getURI() + "\">" + node2.getURI() + "</a>&gt;";
        }
        return "";
    }

    public Map<String, String> getNodeBreadcrumbs(UriInfo uriInfo, Node node) {
        String string = node.getURI();
        this.LOGGER.trace("Generating breadcrumbs for subject {}", (Object)node);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String string2 = uriInfo.getBaseUri().toString();
        if (!string.startsWith(string2)) {
            this.LOGGER.trace("Topic wasn't part of our base URI {}", (Object)string2);
            return builder.build();
        }
        String string3 = string.substring(string2.length());
        String[] stringArray = string3.split("/");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string4 : stringArray) {
            if (string4.isEmpty()) continue;
            stringBuilder.append(string4);
            String string5 = uriInfo.getBaseUriBuilder().path(stringBuilder.toString()).build(new Object[0]).toString();
            this.LOGGER.trace("Adding breadcrumb for path segment {} => {}", (Object)string4, (Object)string5);
            builder.put((Object)string5, (Object)string4);
            stringBuilder.append("/");
        }
        return builder.build();
    }

    public List<Quad> getSortedTriples(Model model, Iterator<Quad> iterator) {
        return Ordering.from((Comparator)new QuadOrdering((PrefixMapping)model)).sortedCopy((Iterable)ImmutableList.copyOf(iterator));
    }

    public String getNamespacePrefix(PrefixMapping prefixMapping, String string) {
        String string2 = prefixMapping.getNsURIPrefix(string);
        if (string2 == null) {
            return string;
        }
        return string2 + ":";
    }

    public String getPrefixPreamble(PrefixMapping prefixMapping) {
        StringBuilder stringBuilder = new StringBuilder();
        Map map = prefixMapping.getNsPrefixMap();
        for (Map.Entry entry : map.entrySet()) {
            stringBuilder.append("PREFIX " + (String)entry.getKey() + ": <" + (String)entry.getValue() + ">\n");
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public Node asNode(Resource resource) {
        return resource.asNode();
    }

    public int addOne(int n) {
        return n + 1;
    }
}

