/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.session;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.sun.jersey.spi.inject.Injectable;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.SecurityContext;
import org.fcrepo.session.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectableSession
implements Injectable<Session> {
    private SessionFactory sessionFactory;
    private SecurityContext secContext;
    private HttpServletRequest request;
    private static final Logger logger = LoggerFactory.getLogger(InjectableSession.class);

    public InjectableSession(SessionFactory sessionFactory, SecurityContext securityContext, HttpServletRequest httpServletRequest) {
        Preconditions.checkNotNull((Object)sessionFactory, (Object)"SessionFactory cannot be null!");
        Preconditions.checkNotNull((Object)securityContext, (Object)"HttpRequestContext cannot be null!");
        Preconditions.checkNotNull((Object)httpServletRequest, (Object)"HttpServletRequest cannot be null!");
        logger.debug("Initializing an InjectableSession with SessionFactory {}.", (Object)sessionFactory);
        this.sessionFactory = sessionFactory;
        this.secContext = securityContext;
        this.request = httpServletRequest;
    }

    public Session getValue() {
        if (this.secContext.getUserPrincipal() != null) {
            logger.debug("Returning authenticated Session.");
            return this.sessionFactory.getSession(this.secContext, this.request);
        }
        logger.debug("Returning unauthenticated Session.");
        try {
            return this.sessionFactory.getSession(this.request);
        }
        catch (RepositoryException repositoryException) {
            Throwables.propagate((Throwable)repositoryException);
            throw new RuntimeException("Couldn't generate an appropriate session from HTTP Request: " + this.request);
        }
    }
}

