/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.session;

import javax.annotation.PostConstruct;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.SecurityContext;
import org.fcrepo.Transaction;
import org.fcrepo.exception.TransactionMissingException;
import org.fcrepo.services.TransactionService;
import org.fcrepo.session.AuthenticatedSessionProvider;
import org.fcrepo.session.AuthenticatedSessionProviderImpl;
import org.modeshape.jcr.api.ServletCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SessionFactory {
    private static final Logger logger = LoggerFactory.getLogger(SessionFactory.class);
    @Autowired
    private Repository repo;
    @Autowired
    private TransactionService transactionService;

    public SessionFactory() {
    }

    public SessionFactory(Repository repository, TransactionService transactionService) {
        this.repo = repository;
        this.transactionService = transactionService;
    }

    @PostConstruct
    public void init() {
        if (this.repo == null) {
            logger.error("SessionFactory requires a Repository instance!");
            throw new IllegalStateException();
        }
    }

    public Session getSession() throws RepositoryException {
        return this.repo.login();
    }

    public Session getSession(String string) throws RepositoryException {
        return this.repo.login(string);
    }

    public Session getSession(HttpServletRequest httpServletRequest) throws RepositoryException {
        Session session;
        String string = this.getEmbeddedWorkspace(httpServletRequest);
        Transaction transaction = this.getEmbeddedTransaction(httpServletRequest);
        if (transaction != null) {
            logger.debug("Returning a session in the transaction {}", (Object)transaction);
            session = transaction.getSession();
        } else if (string != null) {
            logger.debug("Returning a session in the workspace {}", (Object)string);
            session = this.repo.login(string);
        } else {
            logger.debug("Returning a session in the default workspace");
            session = this.repo.login();
        }
        return session;
    }

    public Session getSession(SecurityContext securityContext, HttpServletRequest httpServletRequest) {
        try {
            Session session;
            ServletCredentials servletCredentials = SessionFactory.getCredentials(securityContext, httpServletRequest);
            Transaction transaction = this.getEmbeddedTransaction(httpServletRequest);
            if (transaction != null && servletCredentials != null) {
                logger.debug("Returning a session in the transaction {} impersonating {}", (Object)transaction, (Object)servletCredentials);
                session = transaction.getSession().impersonate((Credentials)servletCredentials);
            } else if (servletCredentials != null) {
                String string = this.getEmbeddedWorkspace(httpServletRequest);
                if (string != null) {
                    logger.debug("Returning an authenticated session in the workspace {}", (Object)string);
                    session = this.repo.login((Credentials)servletCredentials, string);
                } else {
                    logger.debug("Returning an authenticated session in the default workspace");
                    session = this.repo.login((Credentials)servletCredentials);
                }
            } else {
                logger.debug("Falling back on a unauthenticated session");
                session = this.getSession(httpServletRequest);
            }
            return session;
        }
        catch (RepositoryException repositoryException) {
            throw new IllegalStateException(repositoryException);
        }
    }

    public AuthenticatedSessionProvider getSessionProvider(SecurityContext securityContext, HttpServletRequest httpServletRequest) {
        ServletCredentials servletCredentials = SessionFactory.getCredentials(securityContext, httpServletRequest);
        return new AuthenticatedSessionProviderImpl(this.repo, servletCredentials);
    }

    private String getEmbeddedWorkspace(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getPathInfo();
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("/");
        if (stringArray.length > 1 && stringArray[1].startsWith("workspace:")) {
            return stringArray[1].substring("workspace:".length());
        }
        return null;
    }

    private Transaction getEmbeddedTransaction(HttpServletRequest httpServletRequest) throws TransactionMissingException {
        String string = httpServletRequest.getPathInfo();
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("/");
        if (stringArray.length > 1 && stringArray[1].startsWith("tx:")) {
            String string2 = stringArray[1].substring("tx:".length());
            return this.transactionService.getTransaction(string2);
        }
        return null;
    }

    private static ServletCredentials getCredentials(SecurityContext securityContext, HttpServletRequest httpServletRequest) {
        if (securityContext.getUserPrincipal() != null) {
            logger.debug("Authenticated user: " + securityContext.getUserPrincipal().getName());
            return new ServletCredentials(httpServletRequest);
        }
        logger.debug("No authenticated user found!");
        return null;
    }
}

