/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.api.rdf;

import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.sun.jersey.api.uri.UriBuilderImpl;
import java.net.URI;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.ws.rs.Path;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.http.commons.api.rdf.HttpGraphSubjects;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class HttpGraphSubjectsTest {
    private HttpGraphSubjects testObj;
    private String testPath = "/foo/bar";
    @Mock
    private Session mockSession;
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private Resource mockSubject;
    @Mock
    private Node mockNode;
    @Mock
    private ValueFactory mockValueFactory;
    private UriInfo uriInfo;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        this.uriInfo = HttpGraphSubjectsTest.getUriInfoImpl(this.testPath);
        Mockito.when((Object)this.mockSession.getValueFactory()).thenReturn((Object)this.mockValueFactory);
        this.testObj = new HttpGraphSubjects(this.mockSession, MockNodeController.class, this.uriInfo);
    }

    @Test
    public void testGetGraphSubject() throws RepositoryException {
        String expected = "http://localhost:8080/fcrepo/rest" + this.testPath;
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)this.testPath);
        Mockito.when((Object)this.mockWorkspace.getName()).thenReturn((Object)"default");
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        Resource actual = this.testObj.getGraphSubject(this.mockNode);
        Assert.assertEquals((Object)expected, (Object)actual.getURI());
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)(this.testPath + "/jcr:content"));
        actual = this.testObj.getGraphSubject(this.mockNode);
        Assert.assertEquals((Object)(expected + "/fcr:content"), (Object)actual.getURI());
    }

    @Test
    public void testGetNodeFromGraphSubject() throws PathNotFoundException, RepositoryException {
        Mockito.when((Object)this.mockSession.nodeExists(this.testPath)).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getNode(this.testPath)).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockWorkspace.getName()).thenReturn((Object)"default");
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockSubject.getURI()).thenReturn((Object)("http://localhost:8080/fcrepo/rest" + this.testPath));
        Mockito.when((Object)this.mockSubject.isURIResource()).thenReturn((Object)true);
        Node actual = this.testObj.getNodeFromGraphSubject(this.mockSubject);
        ((Session)Mockito.verify((Object)this.mockSession)).getNode(this.testPath);
        Assert.assertEquals((Object)this.mockNode, (Object)actual);
        Mockito.when((Object)this.mockSubject.getURI()).thenReturn((Object)("http://localhost:8080/fcrepo/rest2" + this.testPath + "/bad"));
        actual = this.testObj.getNodeFromGraphSubject(this.mockSubject);
        Assert.assertEquals(null, (Object)actual);
        Mockito.when((Object)this.mockSubject.getURI()).thenReturn((Object)("http://localhost:8080/fcrepo/rest" + this.testPath + "/bad"));
        actual = this.testObj.getNodeFromGraphSubject(this.mockSubject);
        Assert.assertEquals(null, (Object)actual);
        Mockito.when((Object)this.mockSubject.getURI()).thenReturn((Object)("http://localhost:8080/fcrepo/rest" + this.testPath + "/fcr:content"));
        actual = this.testObj.getNodeFromGraphSubject(this.mockSubject);
        ((Session)Mockito.verify((Object)this.mockSession)).getNode(this.testPath + "/jcr:content");
    }

    @Test
    public void testGetNodeFromGraphSubjectForNonJcrUrl() throws RepositoryException {
        Mockito.when((Object)this.mockWorkspace.getName()).thenReturn((Object)"default");
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Assert.assertNull((Object)this.testObj.getNodeFromGraphSubject(ResourceFactory.createResource((String)"http://localhost:8080/fcrepo/rest/abc/fcr:export?format=jcr/xml")));
    }

    @Test
    public void testIsFedoraGraphSubject() {
        Mockito.when((Object)this.mockSubject.getURI()).thenReturn((Object)"http://localhost:8080/fcrepo/rest/foo");
        Mockito.when((Object)this.mockSubject.isURIResource()).thenReturn((Object)true);
        boolean actual = this.testObj.isFedoraGraphSubject(this.mockSubject);
        Assert.assertEquals((Object)true, (Object)actual);
        Mockito.when((Object)this.mockSubject.getURI()).thenReturn((Object)"http://fedora/foo");
        actual = this.testObj.isFedoraGraphSubject(this.mockSubject);
        Assert.assertEquals((Object)false, (Object)actual);
    }

    @Test
    public void testGetContext() {
        Assert.assertEquals((Object)this.uriInfo.getRequestUri().toString(), (Object)this.testObj.getContext().getURI());
    }

    private static UriInfo getUriInfoImpl(String path) {
        UriInfo ui = (UriInfo)Mockito.mock(UriInfo.class);
        UriBuilderImpl ub = new UriBuilderImpl();
        ub.scheme("http");
        ub.host("localhost");
        ub.port(8080);
        ub.path("/fcrepo");
        UriBuilderImpl rb = new UriBuilderImpl();
        rb.scheme("http");
        rb.host("localhost");
        rb.port(8080);
        rb.path("/fcrepo/rest" + path);
        Mockito.when((Object)ui.getRequestUri()).thenReturn((Object)URI.create("http://localhost:8080/fcrepo/rest" + path));
        Mockito.when((Object)ui.getBaseUri()).thenReturn((Object)URI.create("http://localhost:8080/fcrepo"));
        Mockito.when((Object)ui.getBaseUriBuilder()).thenReturn((Object)ub);
        Mockito.when((Object)ui.getAbsolutePathBuilder()).thenReturn((Object)rb);
        return ui;
    }

    @Path(value="/rest/{path}")
    private class MockNodeController {
        private MockNodeController() {
        }
    }
}

