/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.api.rdf;

import com.google.common.collect.ImmutableBiMap;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import javax.jcr.RepositoryException;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.http.commons.api.rdf.HttpTripleUtil;
import org.fcrepo.http.commons.api.rdf.UriAwareResourceModelFactory;
import org.fcrepo.kernel.FedoraResource;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.context.ApplicationContext;

public class HttpTripleUtilTest {
    private HttpTripleUtil testObj;
    private Dataset dataset;
    @Mock
    private UriInfo mockUriInfo;
    @Mock
    private GraphSubjects mockSubjects;
    @Mock
    private UriAwareResourceModelFactory mockBean1;
    @Mock
    private UriAwareResourceModelFactory mockBean2;
    @Mock
    private ApplicationContext mockContext;
    @Mock
    private FedoraResource mockResource;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new HttpTripleUtil();
        this.testObj.setApplicationContext(this.mockContext);
        this.dataset = DatasetFactory.create((Model)ModelFactory.createDefaultModel());
    }

    @Test
    public void shouldAddTriplesFromRegisteredBeans() throws RepositoryException {
        ImmutableBiMap mockBeans = ImmutableBiMap.of((Object)"doesnt", (Object)this.mockBean1, (Object)"matter", (Object)this.mockBean2);
        Mockito.when((Object)this.mockContext.getBeansOfType(UriAwareResourceModelFactory.class)).thenReturn((Object)mockBeans);
        Mockito.when((Object)this.mockBean1.createModelForResource((FedoraResource)Matchers.eq((Object)this.mockResource), (UriInfo)Matchers.eq((Object)this.mockUriInfo), (GraphSubjects)Matchers.eq((Object)this.mockSubjects))).thenReturn((Object)ModelFactory.createDefaultModel());
        Mockito.when((Object)this.mockBean2.createModelForResource((FedoraResource)Matchers.eq((Object)this.mockResource), (UriInfo)Matchers.eq((Object)this.mockUriInfo), (GraphSubjects)Matchers.eq((Object)this.mockSubjects))).thenReturn((Object)ModelFactory.createDefaultModel());
        this.testObj.addHttpComponentModelsForResource(this.dataset, this.mockResource, this.mockUriInfo, this.mockSubjects);
        ((UriAwareResourceModelFactory)Mockito.verify((Object)this.mockBean1)).createModelForResource((FedoraResource)Matchers.eq((Object)this.mockResource), (UriInfo)Matchers.eq((Object)this.mockUriInfo), (GraphSubjects)Matchers.eq((Object)this.mockSubjects));
        ((UriAwareResourceModelFactory)Mockito.verify((Object)this.mockBean2)).createModelForResource((FedoraResource)Matchers.eq((Object)this.mockResource), (UriInfo)Matchers.eq((Object)this.mockUriInfo), (GraphSubjects)Matchers.eq((Object)this.mockSubjects));
    }
}

