/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.google.common.collect.ImmutableMap;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.core.DatasetImpl;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;
import org.fcrepo.http.commons.responses.BaseHtmlProvider;
import org.fcrepo.http.commons.responses.HtmlTemplate;
import org.fcrepo.http.commons.responses.RdfSerializationUtils;
import org.fcrepo.http.commons.test.util.TestHelpers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class BaseHtmlProviderTest {
    final BaseHtmlProvider baseHtmlProvider = new BaseHtmlProvider();
    Dataset testData = new DatasetImpl(ModelFactory.createDefaultModel());

    public BaseHtmlProviderTest() {
        this.testData.asDatasetGraph().getDefaultGraph().add(new Triple(NodeFactory.createURI((String)"test:subject"), NodeFactory.createURI((String)"test:predicate"), NodeFactory.createLiteral((String)"test:object")));
        this.testData.asDatasetGraph().getDefaultGraph().add(new Triple(NodeFactory.createURI((String)"test:subject"), RdfSerializationUtils.primaryTypePredicate, NodeFactory.createLiteral((String)"nt:file")));
    }

    @Test
    public void testIsWriteable() {
        Assert.assertTrue((String)"Gave false response to HtmlProvider.isWriteable() that contained a legitimate combination of parameters!", (boolean)this.baseHtmlProvider.isWriteable(Dataset.class, Dataset.class, null, MediaType.TEXT_HTML_TYPE));
        Assert.assertFalse((String)"HtmlProvider.isWriteable() should return false if asked to serialize anything other than Dataset!", (boolean)this.baseHtmlProvider.isWriteable(BaseHtmlProvider.class, BaseHtmlProvider.class, null, MediaType.TEXT_HTML_TYPE));
        Assert.assertFalse((String)"HtmlProvider.isWriteable() should return false to text/plain!", (boolean)this.baseHtmlProvider.isWriteable(Dataset.class, Dataset.class, null, MediaType.TEXT_PLAIN_TYPE));
    }

    @Test
    public void testGetSize() {
        Assert.assertEquals((String)"Returned wrong size from HtmlProvider!", (long)this.baseHtmlProvider.getSize(null, null, null, null, null), (long)-1L);
    }

    @Test
    public void testWriteTo() throws WebApplicationException, IllegalArgumentException, IOException, NoSuchFieldException {
        Template mockTemplate = (Template)Mockito.mock(Template.class);
        final ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ((Template)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) {
                outStream.write("abcdefighijk".getBytes(), 0, 10);
                return "I am pretending to merge a template for you.";
            }
        }).when((Object)mockTemplate)).merge((Context)Mockito.isA(Context.class), (Writer)Matchers.isA(Writer.class));
        TestHelpers.setField(this.baseHtmlProvider, "templatesMap", ImmutableMap.of((Object)"nt:file", (Object)mockTemplate));
        this.baseHtmlProvider.writeTo(this.testData, Dataset.class, (Type)Mockito.mock(Type.class), new Annotation[0], MediaType.valueOf((String)"text/html"), (MultivaluedMap)new MultivaluedMapImpl(), (OutputStream)outStream);
        byte[] results = outStream.toByteArray();
        Assert.assertTrue((String)"Got no output from serialization!", (results.length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testWriteToWithAnnotation() throws WebApplicationException, IllegalArgumentException, IOException, NoSuchFieldException {
        Template mockTemplate = (Template)Mockito.mock(Template.class);
        final ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ((Template)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) {
                outStream.write("abcdefighijk".getBytes(), 0, 10);
                return "I am pretending to merge a template for you.";
            }
        }).when((Object)mockTemplate)).merge((Context)Mockito.isA(Context.class), (Writer)Matchers.isA(Writer.class));
        TestHelpers.setField(this.baseHtmlProvider, "templatesMap", ImmutableMap.of((Object)"some:file", (Object)mockTemplate));
        HtmlTemplate mockAnnotation = (HtmlTemplate)Mockito.mock(HtmlTemplate.class);
        Mockito.when((Object)mockAnnotation.value()).thenReturn((Object)"some:file");
        this.baseHtmlProvider.writeTo(this.testData, Dataset.class, (Type)Mockito.mock(Type.class), new Annotation[]{mockAnnotation}, MediaType.valueOf((String)"text/html"), (MultivaluedMap)new MultivaluedMapImpl(), (OutputStream)outStream);
        byte[] results = outStream.toByteArray();
        Assert.assertTrue((String)"Got no output from serialization!", (results.length > 0 ? 1 : 0) != 0);
    }
}

