/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.core.DatasetImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.fcrepo.http.commons.responses.QueryExecutionProvider;
import org.fcrepo.http.commons.responses.RdfSerializationUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class QueryExecutionProviderTest {
    final QueryExecutionProvider testObj = new QueryExecutionProvider();
    Dataset testData = new DatasetImpl(ModelFactory.createDefaultModel());

    public QueryExecutionProviderTest() {
        this.testData.asDatasetGraph().getDefaultGraph().add(new Triple(NodeFactory.createURI((String)"test:subject"), NodeFactory.createURI((String)"test:predicate"), NodeFactory.createLiteral((String)"test:object")));
        this.testData.asDatasetGraph().getDefaultGraph().add(new Triple(NodeFactory.createURI((String)"test:subject"), RdfSerializationUtils.primaryTypePredicate, NodeFactory.createLiteral((String)"nt:file")));
    }

    @Test
    public void testWriteTo() throws WebApplicationException, IllegalArgumentException, IOException {
        Query sparqlQuery = QueryFactory.create((String)"SELECT ?x WHERE { ?x ?y ?z }");
        QueryExecution testResult = QueryExecutionFactory.create((Query)sparqlQuery, (Dataset)this.testData);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        this.testObj.writeTo(testResult, QueryExecution.class, (Type)Mockito.mock(Type.class), null, MediaType.valueOf((String)"application/sparql-results+xml"), (MultivaluedMap)Mockito.mock(MultivaluedMap.class), (OutputStream)outStream);
        byte[] results = outStream.toByteArray();
        Assert.assertTrue((String)"Got no output from serialization!", (results.length > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Couldn't find test RDF-object mentioned!", (boolean)new String(results).contains("test:subject"));
    }

    @Test
    public void testGetSize() {
        Assert.assertEquals((String)"Returned wrong size from QueryExecutionProvider!", (long)this.testObj.getSize(null, null, null, null, null), (long)-1L);
    }

    @Test
    public void testIsWritable() throws Exception {
        Assert.assertTrue((String)"Gave false response to QueryExecutionProvider.isWriteable() that contained a legitimate combination of parameters!", (boolean)this.testObj.isWriteable(QueryExecution.class, QueryExecution.class, null, MediaType.valueOf((String)"application/sparql-results+xml")));
        Assert.assertFalse((String)"RdfProvider.isWriteable() should return false if asked to serialize anything other than QueryExecution!", (boolean)this.testObj.isWriteable(QueryExecutionProvider.class, QueryExecutionProvider.class, null, MediaType.valueOf((String)"application/sparql-results+xml")));
        Assert.assertFalse((String)"RdfProvider.isWriteable() should return false to text/html!", (boolean)this.testObj.isWriteable(QueryExecution.class, QueryExecution.class, null, MediaType.TEXT_HTML_TYPE));
    }
}

