/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.core.DatasetImpl;
import com.hp.hpl.jena.sparql.resultset.ResultsFormat;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.ws.rs.core.MediaType;
import org.fcrepo.http.commons.responses.RdfSerializationUtils;
import org.fcrepo.http.commons.responses.ResultSetStreamingOutput;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

public class ResultSetStreamingOutputTest {
    @Mock
    ResultSet mockResultSet;
    ResultSetStreamingOutput testObj;
    Dataset testData = new DatasetImpl(ModelFactory.createDefaultModel());

    public ResultSetStreamingOutputTest() {
        this.testData.asDatasetGraph().getDefaultGraph().add(new Triple(NodeFactory.createURI((String)"test:subject"), NodeFactory.createURI((String)"test:predicate"), NodeFactory.createLiteral((String)"test:object")));
        this.testData.asDatasetGraph().getDefaultGraph().add(new Triple(NodeFactory.createURI((String)"test:subject"), RdfSerializationUtils.primaryTypePredicate, NodeFactory.createLiteral((String)"nt:file")));
    }

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWrite() throws Exception {
        Query sparqlQuery = QueryFactory.create((String)"SELECT ?x WHERE { ?x ?y ?z }");
        try (QueryExecution testResult = QueryExecutionFactory.create((Query)sparqlQuery, (Dataset)this.testData);){
            ResultSet resultSet = testResult.execSelect();
            this.testObj = new ResultSetStreamingOutput(resultSet, MediaType.valueOf((String)"text/tab-separated-values"));
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                this.testObj.write((OutputStream)out);
                String serialized = out.toString();
                Assert.assertTrue((boolean)serialized.contains("test:subject"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteWithRDFFormat() throws Exception {
        Query sparqlQuery = QueryFactory.create((String)"SELECT ?x WHERE { ?x ?y ?z }");
        try (QueryExecution testResult = QueryExecutionFactory.create((Query)sparqlQuery, (Dataset)this.testData);){
            ResultSet resultSet = testResult.execSelect();
            this.testObj = new ResultSetStreamingOutput(resultSet, MediaType.valueOf((String)"application/rdf+xml"));
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                this.testObj.write((OutputStream)out);
                String serialized = out.toString();
                Assert.assertTrue((boolean)serialized.contains("rs:ResultSet"));
            }
        }
    }

    @Test
    public void testGetResultsFormat() throws Exception {
        Assert.assertEquals((Object)ResultsFormat.FMT_RS_TSV, (Object)ResultSetStreamingOutput.getResultsFormat((MediaType)MediaType.valueOf((String)"text/tab-separated-values")));
        Assert.assertEquals((Object)ResultsFormat.FMT_UNKNOWN, (Object)ResultSetStreamingOutput.getResultsFormat((MediaType)MediaType.valueOf((String)"some/type")));
    }
}

