/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons;

import com.google.common.eventbus.EventBus;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.sun.jersey.api.Responses;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.io.IOUtils;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.WebContent;
import org.fcrepo.http.commons.api.rdf.HttpTripleUtil;
import org.fcrepo.http.commons.session.SessionFactory;
import org.fcrepo.kernel.Datastream;
import org.fcrepo.kernel.FedoraObject;
import org.fcrepo.kernel.FedoraResource;
import org.fcrepo.kernel.exception.InvalidChecksumException;
import org.fcrepo.kernel.identifiers.PidMinter;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.fcrepo.kernel.services.DatastreamService;
import org.fcrepo.kernel.services.NodeService;
import org.fcrepo.kernel.services.ObjectService;
import org.modeshape.jcr.api.JcrTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractResource.class);
    @Context
    protected UriInfo uriInfo;
    @Autowired
    protected SessionFactory sessions;
    @Autowired
    protected NodeService nodeService;
    @Autowired
    protected ObjectService objectService;
    @Autowired
    protected DatastreamService datastreamService;
    @Autowired(required=false)
    private HttpTripleUtil httpTripleUtil;
    @Autowired(required=false)
    protected EventBus eventBus;
    @Autowired
    protected PidMinter pidMinter;
    @Context
    private HttpServletRequest servletRequest;
    @Context
    private SecurityContext securityContext;
    protected static final JcrTools jcrTools = new JcrTools(true);

    @PostConstruct
    public void initialize() throws RepositoryException {
    }

    public static final String toPath(List<PathSegment> paths) {
        StringBuffer result = new StringBuffer();
        LOGGER.trace("converting URI path to JCR path: {}", paths);
        int i = 0;
        for (PathSegment path : paths) {
            String p = path.getPath();
            if (p.equals("")) {
                LOGGER.trace("Ignoring empty segment {}", (Object)p);
                continue;
            }
            if (i == 0 && (p.startsWith("tx:") || p.startsWith("workspace:"))) {
                LOGGER.trace("Ignoring internal segment {}", (Object)p);
                ++i;
                continue;
            }
            LOGGER.trace("Adding segment {}", (Object)p);
            if (!p.startsWith("[")) {
                result.append('/');
            }
            result.append(p);
            ++i;
        }
        String path = result.toString();
        if (path.isEmpty()) {
            return "/";
        }
        return path;
    }

    protected FedoraResource createObjectOrDatastreamFromRequestContent(Session session, String path, String mixin, GraphSubjects subjects, InputStream requestBodyStream, MediaType requestContentType, URI checksum) throws RepositoryException, InvalidChecksumException, IOException {
        FedoraObject result;
        block4 : switch (mixin) {
            case "fedora:object": {
                result = this.objectService.createObject(session, path);
                if (requestBodyStream == null || requestContentType == null) break;
                switch (requestContentType.toString()) {
                    case "application/sparql-update": {
                        result.updatePropertiesDataset(subjects, IOUtils.toString((InputStream)requestBodyStream));
                        break block4;
                    }
                }
                String contentType = requestContentType.toString();
                Lang lang = WebContent.contentTypeToLang((String)contentType);
                if (lang == null) {
                    throw new WebApplicationException(Responses.notAcceptable().entity((Object)("Invalid Content type " + contentType)).build());
                }
                String format = lang.getName().toUpperCase();
                Model inputModel = ModelFactory.createDefaultModel().read(requestBodyStream, subjects.getGraphSubject(result.getNode()).toString(), format);
                result.replacePropertiesDataset(subjects, inputModel);
                break;
            }
            case "fedora:datastream": {
                MediaType contentType = requestContentType != null ? requestContentType : MediaType.APPLICATION_OCTET_STREAM_TYPE;
                Node node = this.datastreamService.createDatastreamNode(session, path, contentType.toString(), requestBodyStream, checksum);
                result = new Datastream(node);
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    protected void addResponseInformationToDataset(FedoraResource resource, Dataset dataset, UriInfo uriInfo, GraphSubjects subjects) throws RepositoryException {
        if (this.httpTripleUtil != null) {
            this.httpTripleUtil.addHttpComponentModelsForResource(dataset, resource, uriInfo, subjects);
        }
    }
}

