/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.tools.generic.EscapeTool;
import org.apache.velocity.tools.generic.FieldTool;
import org.fcrepo.http.commons.responses.HtmlTemplate;
import org.fcrepo.http.commons.responses.RdfSerializationUtils;
import org.fcrepo.http.commons.responses.ViewHelpers;
import org.fcrepo.http.commons.session.SessionFactory;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.rdf.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Provider
public class BaseHtmlProvider
implements MessageBodyWriter<Dataset> {
    @Autowired
    SessionFactory sessionFactory;
    @Context
    UriInfo uriInfo;
    private static EscapeTool escapeTool = new EscapeTool();
    protected VelocityEngine velocity = new VelocityEngine();
    public static final String templatesLocation = "/views";
    protected Map<String, Template> templatesMap;
    public static final String templateFilenameExtension = ".vsl";
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseHtmlProvider.class);
    public static final String velocityPropertiesLocation = "/velocity.properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    void init() throws IOException, RepositoryException {
        LOGGER.trace("Velocity engine initializing...");
        Properties properties = new Properties();
        URL propertiesUrl = this.getClass().getResource(velocityPropertiesLocation);
        LOGGER.debug("Using Velocity configuration from {}", (Object)propertiesUrl);
        try (InputStream propertiesStream = propertiesUrl.openStream();){
            properties.load(propertiesStream);
        }
        this.velocity.init(properties);
        LOGGER.trace("Velocity engine initialized.");
        LOGGER.trace("Assembling a map of node primary types -> templates...");
        ImmutableMap.Builder templatesMapBuilder = ImmutableMap.builder();
        Session session = this.sessionFactory.getInternalSession();
        try {
            Template template;
            NodeTypeIterator primaryNodeTypes = session.getWorkspace().getNodeTypeManager().getPrimaryNodeTypes();
            while (primaryNodeTypes.hasNext()) {
                String primaryNodeTypeName = primaryNodeTypes.nextNodeType().getName();
                String templateLocation = "/views/" + primaryNodeTypeName.replace(':', '-') + templateFilenameExtension;
                if (this.velocity.resourceExists(templateLocation)) {
                    template = this.velocity.getTemplate(templateLocation);
                    template.setName(templateLocation);
                    LOGGER.debug("Found template: {}", (Object)templateLocation);
                    templatesMapBuilder.put((Object)primaryNodeTypeName, (Object)template);
                    LOGGER.debug("which we will use for nodes with primary type: {}", (Object)primaryNodeTypeName);
                    continue;
                }
                LOGGER.debug("Didn't find template for nodes with primary type: {} in location: {}", (Object)primaryNodeTypeName, (Object)templateLocation);
            }
            ImmutableList otherTemplates = ImmutableList.of((Object)"search:results", (Object)"jcr:namespaces", (Object)"jcr:workspaces", (Object)"node");
            for (String key : otherTemplates) {
                template = this.velocity.getTemplate("/views/" + key.replace(':', '-') + templateFilenameExtension);
                templatesMapBuilder.put((Object)key, (Object)template);
            }
            this.templatesMap = templatesMapBuilder.build();
        }
        finally {
            session.logout();
        }
        LOGGER.trace("Assembled template map.");
        LOGGER.trace("HtmlProvider initialization complete.");
    }

    public void writeTo(Dataset rdf, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        LOGGER.debug("Writing an HTML response for: {}", (Object)rdf);
        LOGGER.trace("Attempting to discover our subject");
        Node subject = SerializationUtils.getDatasetSubject((Dataset)rdf);
        httpHeaders.put((Object)"Content-type", (Object)ImmutableList.of((Object)"text/html"));
        RdfSerializationUtils.setCachingHeaders(httpHeaders, rdf);
        Template nodeTypeTemplate = this.getTemplate(rdf, subject, annotations);
        org.apache.velocity.context.Context context = this.getContext(rdf, subject);
        OutputStreamWriter outWriter = new OutputStreamWriter(entityStream);
        nodeTypeTemplate.merge(context, (Writer)outWriter);
        ((Writer)outWriter).flush();
    }

    protected org.apache.velocity.context.Context getContext(Dataset rdf, Node subject) {
        FieldTool fieldTool = new FieldTool();
        VelocityContext context = new VelocityContext();
        context.put("rdfLexicon", (Object)fieldTool.in(RdfLexicon.class));
        context.put("helpers", (Object)ViewHelpers.getInstance());
        context.put("esc", (Object)escapeTool);
        context.put("rdf", (Object)rdf.asDatasetGraph());
        Model model = SerializationUtils.unifyDatasetModel((Dataset)rdf);
        context.put("model", (Object)model);
        context.put("subjects", (Object)model.listSubjects());
        context.put("nodeany", (Object)Node.ANY);
        context.put("topic", (Object)subject);
        context.put("uriInfo", (Object)this.uriInfo);
        return context;
    }

    private Template getTemplate(Dataset rdf, Node subject, Annotation[] annotations) {
        Template template = null;
        for (Annotation a : annotations) {
            if (!(a instanceof HtmlTemplate)) continue;
            String value = ((HtmlTemplate)a).value();
            LOGGER.debug("Found an HtmlTemplate annotation {}", (Object)value);
            template = this.templatesMap.get(value);
            break;
        }
        if (template == null) {
            LOGGER.trace("Attempting to discover the primary type of the node for the resource in question...");
            String nodeType = RdfSerializationUtils.getFirstValueForPredicate(rdf, subject, RdfSerializationUtils.primaryTypePredicate);
            LOGGER.debug("Found primary node type: {}", (Object)nodeType);
            template = this.templatesMap.get(nodeType);
        }
        if (template == null) {
            LOGGER.debug("Falling back on default node template");
            template = this.templatesMap.get("node");
        }
        LOGGER.debug("Choosing template: {}", (Object)template.getName());
        return template;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return mediaType.equals((Object)MediaType.TEXT_HTML_TYPE) && (Dataset.class.isAssignableFrom(type) || Dataset.class.isAssignableFrom(genericType.getClass()));
    }

    public long getSize(Dataset t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }
}

