/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.google.common.collect.ImmutableList;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.resultset.ResultsFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.fcrepo.http.commons.responses.ResultSetStreamingOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Provider
@Component
public class QueryExecutionProvider
implements MessageBodyWriter<QueryExecution> {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecutionProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(QueryExecution qexec, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        logger.debug("Writing a response for: {} with MIMEtype: {}", (Object)qexec, (Object)mediaType);
        httpHeaders.put((Object)"Content-type", (Object)ImmutableList.of((Object)mediaType.toString()));
        try {
            ResultSet results = qexec.execSelect();
            new ResultSetStreamingOutput(results, mediaType).write(entityStream);
        }
        finally {
            qexec.close();
        }
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        Boolean appropriateResultType = ResultSetStreamingOutput.getResultsFormat(mediaType) != ResultsFormat.FMT_UNKNOWN;
        return appropriateResultType != false && (QueryExecution.class.isAssignableFrom(type) || QueryExecution.class.isAssignableFrom(genericType.getClass()));
    }

    public long getSize(QueryExecution rdf, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }
}

