/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.http.commons.api.rdf.QuadOrdering;
import org.fcrepo.kernel.RdfLexicon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewHelpers {
    private final Logger LOGGER = LoggerFactory.getLogger(ViewHelpers.class);
    private static ViewHelpers instance = null;

    protected ViewHelpers() {
    }

    public static ViewHelpers getInstance() {
        if (instance == null) {
            instance = new ViewHelpers();
        }
        return instance;
    }

    public Iterator<Quad> getObjects(DatasetGraph dataset, Node subject, Resource predicate) {
        return dataset.find(Node.ANY, subject, predicate.asNode(), Node.ANY);
    }

    public String getObjectTitle(DatasetGraph dataset, Node subject) {
        Property[] properties;
        for (Property p : properties = new Property[]{RdfLexicon.RDFS_LABEL, RdfLexicon.DC_TITLE}) {
            Iterator<Quad> objects = this.getObjects(dataset, subject, (Resource)p);
            if (!objects.hasNext()) continue;
            return objects.next().getObject().getLiteralValue().toString();
        }
        if (subject.isURI()) {
            return subject.getURI();
        }
        if (subject.isBlank()) {
            return subject.getBlankNodeLabel();
        }
        return subject.toString();
    }

    public String getObjectsAsString(DatasetGraph dataset, Node subject, Resource predicate) {
        Iterator<Quad> iterator = this.getObjects(dataset, subject, predicate);
        if (iterator.hasNext()) {
            Node object = iterator.next().getObject();
            if (object.isLiteral()) {
                String s = object.getLiteralValue().toString();
                if (s.isEmpty()) {
                    return "<empty>";
                }
                return s;
            }
            return "&lt;<a href=\"" + object.getURI() + "\">" + object.getURI() + "</a>&gt;";
        }
        return "";
    }

    public Map<String, String> getNodeBreadcrumbs(UriInfo uriInfo, Node subject) {
        String topic = subject.getURI();
        this.LOGGER.trace("Generating breadcrumbs for subject {}", (Object)subject);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String baseUri = uriInfo.getBaseUri().toString();
        if (!topic.startsWith(baseUri)) {
            this.LOGGER.trace("Topic wasn't part of our base URI {}", (Object)baseUri);
            return builder.build();
        }
        String salientPath = topic.substring(baseUri.length());
        String[] split = salientPath.split("/");
        StringBuilder cumulativePath = new StringBuilder();
        for (String path : split) {
            if (path.isEmpty()) continue;
            cumulativePath.append(path);
            String uri = uriInfo.getBaseUriBuilder().path(cumulativePath.toString()).build(new Object[0]).toString();
            this.LOGGER.trace("Adding breadcrumb for path segment {} => {}", (Object)path, (Object)uri);
            builder.put((Object)uri, (Object)path);
            cumulativePath.append("/");
        }
        return builder.build();
    }

    public List<Quad> getSortedTriples(Model model, Iterator<Quad> it) {
        return Ordering.from((Comparator)new QuadOrdering((PrefixMapping)model)).sortedCopy((Iterable)ImmutableList.copyOf(it));
    }

    public String getNamespacePrefix(PrefixMapping mapping, String namespace) {
        String nsURIPrefix = mapping.getNsURIPrefix(namespace);
        if (nsURIPrefix == null) {
            return namespace;
        }
        return nsURIPrefix + ":";
    }

    public String getPrefixPreamble(PrefixMapping mapping) {
        StringBuilder sb = new StringBuilder();
        Map nsPrefixMap = mapping.getNsPrefixMap();
        for (Map.Entry entry : nsPrefixMap.entrySet()) {
            sb.append("PREFIX " + (String)entry.getKey() + ": <" + (String)entry.getValue() + ">\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    public Node asNode(Resource r) {
        return r.asNode();
    }

    public int addOne(int i) {
        return i + 1;
    }
}

