/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.session;

import com.google.common.base.Preconditions;
import com.sun.jersey.spi.inject.Injectable;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.SecurityContext;
import org.fcrepo.http.commons.session.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectableSession
implements Injectable<Session> {
    private SessionFactory sessionFactory;
    private SecurityContext secContext;
    private HttpServletRequest request;
    private static final Logger logger = LoggerFactory.getLogger(InjectableSession.class);

    public InjectableSession(SessionFactory sessionFactory, SecurityContext reqContext, HttpServletRequest request) {
        Preconditions.checkNotNull((Object)sessionFactory, (Object)"SessionFactory cannot be null!");
        Preconditions.checkNotNull((Object)reqContext, (Object)"HttpRequestContext cannot be null!");
        Preconditions.checkNotNull((Object)request, (Object)"HttpServletRequest cannot be null!");
        logger.debug("Initializing an InjectableSession with SessionFactory {}.", (Object)sessionFactory);
        this.sessionFactory = sessionFactory;
        this.secContext = reqContext;
        this.request = request;
    }

    public Session getValue() {
        return this.sessionFactory.getSession(this.secContext, this.request);
    }
}

