/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.session;

import javax.annotation.PostConstruct;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.SecurityContext;
import org.fcrepo.http.commons.session.AuthenticatedSessionProvider;
import org.fcrepo.http.commons.session.AuthenticatedSessionProviderImpl;
import org.fcrepo.kernel.Transaction;
import org.fcrepo.kernel.exception.TransactionMissingException;
import org.fcrepo.kernel.services.TransactionService;
import org.modeshape.jcr.api.ServletCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SessionFactory {
    private static final Logger logger = LoggerFactory.getLogger(SessionFactory.class);
    @Autowired
    private Repository repo;
    @Autowired
    private TransactionService transactionService;

    public SessionFactory() {
    }

    public SessionFactory(Repository repo, TransactionService transactionService) {
        this.repo = repo;
        this.transactionService = transactionService;
    }

    @PostConstruct
    public void init() {
        if (this.repo == null) {
            logger.error("SessionFactory requires a Repository instance!");
            throw new IllegalStateException();
        }
    }

    public Session getInternalSession() throws RepositoryException {
        return this.repo.login();
    }

    public Session getInternalSession(String workspace) throws RepositoryException {
        return this.repo.login(workspace);
    }

    public Session getSession(HttpServletRequest servletRequest) throws RepositoryException {
        Session session;
        String workspace = this.getEmbeddedWorkspace(servletRequest);
        Transaction transaction = this.getEmbeddedTransaction(servletRequest);
        if (transaction != null) {
            logger.debug("Returning a session in the transaction {}", (Object)transaction);
            session = transaction.getSession();
        } else if (workspace != null) {
            logger.debug("Returning a session in the workspace {}", (Object)workspace);
            session = this.repo.login(workspace);
        } else {
            logger.debug("Returning a session in the default workspace");
            session = this.repo.login();
        }
        return session;
    }

    public Session getSession(SecurityContext securityContext, HttpServletRequest servletRequest) {
        try {
            Session session;
            ServletCredentials creds = new ServletCredentials(servletRequest);
            Transaction transaction = this.getEmbeddedTransaction(servletRequest);
            if (transaction != null && creds != null) {
                logger.debug("Returning a session in the transaction {} impersonating {}", (Object)transaction, (Object)creds);
                HttpSession httpSession = servletRequest.getSession(true);
                session = httpSession != null && transaction.getId().equals(httpSession.getAttribute("currentTx")) ? transaction.getSession() : transaction.getSession().impersonate((Credentials)creds);
            } else if (creds != null) {
                String workspace = this.getEmbeddedWorkspace(servletRequest);
                if (workspace != null) {
                    logger.debug("Returning an authenticated session in the workspace {}", (Object)workspace);
                    session = this.repo.login((Credentials)creds, workspace);
                } else {
                    logger.debug("Returning an authenticated session in the default workspace");
                    session = this.repo.login((Credentials)creds);
                }
            } else {
                logger.debug("Falling back on a unauthenticated session");
                session = this.getSession(servletRequest);
            }
            return session;
        }
        catch (RepositoryException e) {
            throw new IllegalStateException(e);
        }
    }

    public AuthenticatedSessionProvider getSessionProvider(SecurityContext securityContext, HttpServletRequest servletRequest) {
        ServletCredentials creds = new ServletCredentials(servletRequest);
        return new AuthenticatedSessionProviderImpl(this.repo, (Credentials)creds);
    }

    private String getEmbeddedWorkspace(HttpServletRequest request) {
        String requestPath = request.getPathInfo();
        if (requestPath == null) {
            return null;
        }
        String[] part = requestPath.split("/");
        if (part.length > 1 && part[1].startsWith("workspace:")) {
            return part[1].substring("workspace:".length());
        }
        return null;
    }

    private Transaction getEmbeddedTransaction(HttpServletRequest servletRequest) throws TransactionMissingException {
        String requestPath = servletRequest.getPathInfo();
        if (requestPath == null) {
            return null;
        }
        String[] part = requestPath.split("/");
        if (part.length > 1 && part[1].startsWith("tx:")) {
            String txid = part[1].substring("tx:".length());
            return this.transactionService.getTransaction(txid);
        }
        return null;
    }
}

