/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.sparql.core.DatasetImpl;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.Calendar;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.fcrepo.http.commons.responses.RdfSerializationUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;

public class RdfSerializationUtilsTest {
    Dataset testData = new DatasetImpl(ModelFactory.createDefaultModel());

    public RdfSerializationUtilsTest() {
        this.testData.asDatasetGraph().getDefaultGraph().add(new Triple(NodeFactory.createURI((String)"test:subject"), NodeFactory.createURI((String)"test:predicate"), NodeFactory.createLiteral((String)"test:object")));
    }

    @Test
    public void testGetFirstValueForPredicate() {
        String foundValue = RdfSerializationUtils.getFirstValueForPredicate((Dataset)this.testData, (Node)Node.ANY, (Node)NodeFactory.createURI((String)"test:predicate"));
        Assert.assertEquals((String)"Didn't find correct value for predicate!", (Object)foundValue, (Object)"test:object");
    }

    @Test
    public void testSetCachingHeaders() {
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        RdfSerializationUtils.setCachingHeaders((MultivaluedMap)headers, (Dataset)this.testData);
        Assert.assertTrue((((List)headers.get((Object)"Cache-Control")).size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSetCachingHeadersWithLastModified() {
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        Model m = ModelFactory.createDefaultModel();
        Calendar c = Calendar.getInstance();
        m.add(m.createResource("test:subject"), m.createProperty(RdfSerializationUtils.lastModifiedPredicate.getURI()), (RDFNode)m.createTypedLiteral(c));
        Dataset testDatasetWithLastModified = DatasetFactory.create((Model)m);
        Context context = testDatasetWithLastModified.getContext();
        context.set(Symbol.create((String)"uri"), (Object)"test:subject");
        RdfSerializationUtils.setCachingHeaders((MultivaluedMap)headers, (Dataset)testDatasetWithLastModified);
        Assert.assertTrue((boolean)new DateTime((Object)c).withMillisOfSecond(0).isEqual((ReadableInstant)RdfSerializationUtils.RFC2822DATEFORMAT.parseDateTime((String)((List)headers.get((Object)"Last-Modified")).get(0))));
    }
}

