/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.session;

import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.spi.inject.Injectable;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.SecurityContext;
import org.fcrepo.http.commons.session.InjectableSession;
import org.fcrepo.http.commons.session.InjectedSession;
import org.fcrepo.http.commons.session.SessionFactory;
import org.fcrepo.http.commons.session.SessionProvider;
import org.fcrepo.http.commons.test.util.TestHelpers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class SessionProviderTest {
    SessionProvider testObj;
    @Mock
    private Session mockSession;
    @Mock
    private SessionFactory mockSessionFactory;
    @Mock
    private SecurityContext mockSecurityContext;
    @Mock
    private ComponentContext con;
    @Mock
    private InjectedSession in;
    @Mock
    private HttpServletRequest mockHttpServletRequest;

    @Before
    public void setUp() throws RepositoryException, NoSuchFieldException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockSessionFactory.getInternalSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSessionFactory.getSession(this.mockSecurityContext, this.mockHttpServletRequest)).thenReturn((Object)this.mockSession);
        this.testObj = new SessionProvider();
        TestHelpers.setField(this.testObj, "sessionFactory", this.mockSessionFactory);
        TestHelpers.setField(this.testObj, "secContext", this.mockSecurityContext);
        TestHelpers.setField(this.testObj, "request", this.mockHttpServletRequest);
    }

    @Test
    public void testGetInjectable() {
        Injectable inj = this.testObj.getInjectable(this.con, this.in);
        Assert.assertNotNull((String)"Didn't get an Injectable<Session>!", (Object)inj);
        Assert.assertTrue((String)"Didn't get an InjectableSession!", (boolean)InjectableSession.class.isAssignableFrom(inj.getClass()));
    }
}

