/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.test.util;

import com.sun.jersey.api.container.grizzly2.GrizzlyServerFactory;
import java.net.URI;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.fcrepo.http.commons.webxml.WebAppConfig;
import org.fcrepo.http.commons.webxml.bind.ContextParam;
import org.fcrepo.http.commons.webxml.bind.Filter;
import org.fcrepo.http.commons.webxml.bind.FilterMapping;
import org.fcrepo.http.commons.webxml.bind.InitParam;
import org.fcrepo.http.commons.webxml.bind.Listener;
import org.fcrepo.http.commons.webxml.bind.Servlet;
import org.fcrepo.http.commons.webxml.bind.UrlMappable;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.servlet.FilterRegistration;
import org.glassfish.grizzly.servlet.ServletRegistration;
import org.glassfish.grizzly.servlet.WebappContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ContainerWrapper
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(ContainerWrapper.class);
    private int port;
    private HttpServer server;
    private WebappContext appContext;
    private String configLocation;

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation.replaceFirst("^classpath:", "/");
    }

    public void setPort(int port) {
        this.port = port;
    }

    @PostConstruct
    public void start() throws Exception {
        Collection<UrlMappable> mappings;
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{WebAppConfig.class});
        Unmarshaller u = context.createUnmarshaller();
        WebAppConfig o = (WebAppConfig)u.unmarshal(this.getClass().getResource(this.configLocation));
        URI uri = URI.create("http://localhost:" + this.port);
        this.server = GrizzlyServerFactory.createHttpServer((URI)uri, (HttpHandler)new HttpHandler(){

            public void service(Request req, Response res) throws Exception {
                res.setStatus(404, "Not found");
                res.getWriter().write("404: not found");
            }
        });
        this.appContext = new WebappContext(o.displayName(), "/");
        for (ContextParam p : o.contextParams()) {
            this.appContext.addContextInitParameter(p.name(), p.value());
        }
        for (Listener l : o.listeners()) {
            this.appContext.addListener(l.className());
        }
        for (Servlet s : o.servlets()) {
            ServletRegistration servlet = this.appContext.addServlet(s.servletName(), s.servletClass());
            mappings = o.servletMappings(s.servletName());
            for (UrlMappable sm : mappings) {
                servlet.addMapping(new String[]{sm.urlPattern()});
            }
            for (InitParam p : s.initParams()) {
                servlet.setInitParameter(p.name(), p.value());
            }
        }
        for (Filter f : o.filters()) {
            FilterRegistration filter = this.appContext.addFilter(f.filterName(), f.filterClass());
            mappings = o.filterMappings(f.filterName());
            for (UrlMappable sm : mappings) {
                String urlPattern = sm.urlPattern();
                String servletName = ((FilterMapping)sm).servletName();
                if (urlPattern != null) {
                    filter.addMappingForUrlPatterns(null, new String[]{urlPattern});
                    continue;
                }
                filter.addMappingForServletNames(null, new String[]{servletName});
            }
            for (InitParam p : f.initParams()) {
                filter.setInitParameter(p.name(), p.value());
            }
        }
        this.appContext.deploy(this.server);
        logger.debug("started grizzly webserver endpoint at " + this.server.getHttpHandler().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void stop() {
        try {
            this.appContext.undeploy();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        finally {
            this.server.shutdownNow();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
    }
}

