/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.api.rdf;

import com.google.common.base.Function;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.Workspace;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.fcrepo.kernel.services.TransactionService;
import org.fcrepo.kernel.services.functions.GetDefaultWorkspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpGraphSubjects
implements GraphSubjects {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpGraphSubjects.class);
    public static final String WORKSPACE_PREFIX = "workspace:";
    public static final String TX_PREFIX = "tx:";
    private final UriBuilder nodesBuilder;
    private final String basePath;
    private final int pathIx;
    private final URI context;
    private final Session session;
    private final String defaultWorkspace;
    private Function<Repository, String> getDefaultWorkspace = new GetDefaultWorkspace();

    public HttpGraphSubjects(Session session, Class<?> relativeTo, UriInfo uris) {
        this.context = uris.getRequestUri();
        this.nodesBuilder = uris.getBaseUriBuilder().path(relativeTo);
        String normalizedBasePath = this.nodesBuilder.build(new Object[]{""}).toString();
        if (!normalizedBasePath.endsWith("/")) {
            normalizedBasePath = normalizedBasePath + "/";
        }
        this.basePath = normalizedBasePath;
        this.pathIx = normalizedBasePath.length() - 1;
        this.session = session;
        this.defaultWorkspace = (String)this.getDefaultWorkspace.apply((Object)session.getRepository());
        LOGGER.debug("Resolving graph subjects to a base URI of \"{}\"", (Object)normalizedBasePath);
    }

    public Resource getGraphSubject(String absPath) throws RepositoryException {
        URI result = this.nodesBuilder.buildFromMap(this.getPathMap(absPath));
        LOGGER.debug("Translated path {} into RDF subject {}", (Object)absPath, (Object)result);
        return ResourceFactory.createResource((String)result.toString());
    }

    public Resource getContext() {
        return ResourceFactory.createResource((String)this.context.toString());
    }

    public Resource getGraphSubject(Node node) throws RepositoryException {
        URI result = this.nodesBuilder.buildFromMap(this.getPathMap(node));
        LOGGER.debug("Translated node {} into RDF subject {}", (Object)node, (Object)result);
        return ResourceFactory.createResource((String)result.toString());
    }

    public Node getNodeFromGraphSubject(Resource subject) throws RepositoryException {
        Node node;
        String absPath = this.getPathFromGraphSubject(subject);
        if (absPath == null) {
            return null;
        }
        if (this.session.nodeExists(absPath)) {
            node = this.session.getNode(absPath);
            LOGGER.trace("RDF resource {} maps to JCR node {}", (Object)subject, (Object)node);
        } else {
            node = null;
            LOGGER.debug("RDF resource {} looks like a Fedora node, but when we checked was not in the repository", (Object)subject);
        }
        return node;
    }

    public String getPathFromGraphSubject(Resource subject) throws RepositoryException {
        String[] pathSegments;
        if (!this.isFedoraGraphSubject(subject)) {
            LOGGER.debug("RDF resource {} was not a URI resource with our expected basePath {}, aborting.", (Object)subject, (Object)this.basePath);
            return null;
        }
        StringBuilder pathBuilder = new StringBuilder();
        for (String segment : pathSegments = subject.getURI().substring(this.pathIx).split("/")) {
            if (segment.startsWith(TX_PREFIX)) {
                String tx = segment.substring(TX_PREFIX.length());
                String currentTxId = TransactionService.getCurrentTransactionId((Session)this.session);
                if (currentTxId != null && tx.equals(currentTxId)) continue;
                throw new RepositoryException("Subject is not in this transaction");
            }
            if (segment.startsWith(WORKSPACE_PREFIX)) {
                String workspace = segment.substring(WORKSPACE_PREFIX.length());
                if (this.session.getWorkspace().getName().equals(workspace)) continue;
                throw new RepositoryException("Subject is not in this workspace");
            }
            if (segment.equals("fcr:content")) {
                pathBuilder.append("/");
                pathBuilder.append("jcr:content");
                continue;
            }
            if (segment.isEmpty()) continue;
            pathBuilder.append("/");
            pathBuilder.append(segment);
        }
        String absPath = pathBuilder.length() == 0 ? "/" : pathBuilder.toString();
        if (this.isValidJcrPath(absPath)) {
            return absPath;
        }
        return null;
    }

    private boolean isValidJcrPath(String absPath) {
        try {
            this.session.getValueFactory().createValue(absPath, 8);
            return true;
        }
        catch (ValueFormatException e) {
            LOGGER.trace("Unable to validate JCR path", (Throwable)e);
            return false;
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException("Unable to validate JCR path", (Throwable)e);
        }
    }

    public boolean isFedoraGraphSubject(Resource subject) {
        return subject.isURIResource() && subject.getURI().startsWith(this.basePath) && this.isValidJcrPath(subject.getURI().substring(this.pathIx));
    }

    private Map<String, String> getPathMap(Node node) throws RepositoryException {
        return this.getPathMap(node.getPath());
    }

    private Map<String, String> getPathMap(String absPath) throws RepositoryException {
        String path = absPath.substring(1);
        if (path.endsWith("jcr:content")) {
            path = path.replace("jcr:content", "fcr:content");
        }
        if (this.session != null) {
            Workspace workspace = this.session.getWorkspace();
            String txId = TransactionService.getCurrentTransactionId((Session)this.session);
            if (txId != null) {
                path = TX_PREFIX + txId + "/" + path;
            } else if (workspace != null && !workspace.getName().equals(this.defaultWorkspace)) {
                path = WORKSPACE_PREFIX + workspace.getName() + "/" + path;
            }
        }
        return Collections.singletonMap("path", path);
    }
}

