/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.update.GraphStore;
import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.StreamingOutput;
import org.apache.jena.riot.WebContent;
import org.fcrepo.kernel.rdf.SerializationUtils;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphStoreStreamingOutput
implements StreamingOutput {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphStoreStreamingOutput.class);
    private final Dataset dataset;
    private final String format;

    public GraphStoreStreamingOutput(GraphStore graphStore, MediaType mediaType) {
        this(graphStore.toDataset(), mediaType);
    }

    public GraphStoreStreamingOutput(Dataset dataset, MediaType mediaType) {
        this.dataset = dataset;
        this.format = WebContent.contentTypeToLang((String)mediaType.toString()).getName().toUpperCase();
    }

    public GraphStoreStreamingOutput(RdfStream stream, MediaType mediaType) {
        this.dataset = DatasetFactory.create((Model)stream.asModel());
        this.format = WebContent.contentTypeToLang((String)mediaType.toString()).getName().toUpperCase();
    }

    public void write(OutputStream out) throws IOException {
        LOGGER.debug("Serializing graph  as {}", (Object)this.format);
        LOGGER.debug("Serializing default model");
        Model model = SerializationUtils.unifyDatasetModel((Dataset)this.dataset);
        model.write(out, this.format);
    }
}

