/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons;

import java.util.List;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.http.commons.AbstractResource;
import org.fcrepo.http.commons.test.util.PathSegmentImpl;
import org.fcrepo.http.commons.test.util.TestHelpers;
import org.fcrepo.kernel.identifiers.PidMinter;
import org.fcrepo.kernel.services.NodeService;
import org.fcrepo.kernel.utils.NamespaceTools;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.api.NamespaceRegistry;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "javax.xml.parsers.*", "org.apache.xerces.*"})
@PrepareForTest(value={NamespaceTools.class})
public class AbstractResourceTest {
    private AbstractResource testObj;
    @Mock
    private NodeService mockNodes;
    @Mock
    private PidMinter mockPids;
    @Mock
    private UriInfo mockUris;
    @Mock
    private NamespaceRegistry mockNames;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new AbstractResource(){};
    }

    @Test
    public void testSetPidMinter() throws Exception {
        TestHelpers.setField(this.testObj, "pidMinter", this.mockPids);
        Assert.assertEquals((Object)this.mockPids, (Object)this.testObj.pidMinter);
    }

    @Test
    public void testSetNodeService() throws Exception {
        TestHelpers.setField(this.testObj, "nodeService", this.mockNodes);
        Assert.assertEquals((Object)this.mockNodes, (Object)this.testObj.nodeService);
    }

    @Test
    public void testSetUriInfo() throws Exception {
        TestHelpers.setField(this.testObj, "uriInfo", this.mockUris);
        Assert.assertEquals((Object)this.mockUris, (Object)this.testObj.uriInfo);
    }

    @Test
    public void testToPath() {
        List<PathSegment> pathList = PathSegmentImpl.createPathList("foo", "", "bar", "baz");
        String expected = "/foo/bar/baz";
        String actual = AbstractResource.toPath(pathList);
        Assert.assertEquals((Object)"/foo/bar/baz", (Object)actual);
    }

    @Test
    public void testToPathWorkspace() {
        List<PathSegment> pathList = PathSegmentImpl.createPathList("workspace:abc", "bar", "baz");
        String expected = "/bar/baz";
        String actual = AbstractResource.toPath(pathList);
        Assert.assertEquals((Object)"/bar/baz", (Object)actual);
    }

    @Test
    public void testToPathWorkspaceInSomeOtherSegment() {
        List<PathSegment> pathList = PathSegmentImpl.createPathList("asdf", "workspace:abc", "bar", "baz");
        String expected = "/asdf/workspace:abc/bar/baz";
        String actual = AbstractResource.toPath(pathList);
        Assert.assertEquals((Object)"/asdf/workspace:abc/bar/baz", (Object)actual);
    }

    @Test
    public void testToPathWorkspaceWithEmptyPrefix() {
        List<PathSegment> pathList = PathSegmentImpl.createPathList("", "workspace:abc", "bar", "baz");
        String expected = "/bar/baz";
        String actual = AbstractResource.toPath(pathList);
        Assert.assertEquals((Object)"/bar/baz", (Object)actual);
    }

    @Test
    public void testToPathTransaction() {
        List<PathSegment> pathList = PathSegmentImpl.createPathList("tx:abc", "bar", "baz");
        String expected = "/bar/baz";
        String actual = AbstractResource.toPath(pathList);
        Assert.assertEquals((Object)"/bar/baz", (Object)actual);
    }

    @Test
    public void testToPathTxInSomeOtherSegment() {
        List<PathSegment> pathList = PathSegmentImpl.createPathList("asdf", "tx:abc", "bar", "baz");
        String expected = "/asdf/tx:abc/bar/baz";
        String actual = AbstractResource.toPath(pathList);
        Assert.assertEquals((Object)"/asdf/tx:abc/bar/baz", (Object)actual);
    }

    @Test
    public void testToPathTxWithEmptyPrefix() {
        List<PathSegment> pathList = PathSegmentImpl.createPathList("", "tx:abc", "bar", "baz");
        String expected = "/bar/baz";
        String actual = AbstractResource.toPath(pathList);
        Assert.assertEquals((Object)"/bar/baz", (Object)actual);
    }

    @Test
    public void testToPathUuid() {
        List<PathSegment> pathList = PathSegmentImpl.createPathList("[foo]");
        String expected = "[foo]";
        String actual = AbstractResource.toPath(pathList);
        Assert.assertEquals((Object)"[foo]", (Object)actual);
    }

    @Test
    public void testToPathEmpty() {
        List<PathSegment> pathList = PathSegmentImpl.createPathList(new String[0]);
        String expected = "/";
        String actual = AbstractResource.toPath(pathList);
        Assert.assertEquals((Object)"/", (Object)actual);
    }
}

