/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.api.rdf;

import com.hp.hpl.jena.rdf.model.Resource;
import com.sun.jersey.api.uri.UriBuilderImpl;
import java.net.URI;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.ws.rs.Path;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.kernel.TxSession;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.junit.Before;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public abstract class GraphSubjectsTest {
    protected String testPath = "/foo/bar";
    protected GraphSubjects testObj;
    @Mock
    protected Session mockSession;
    @Mock
    protected TxSession mockSessionTx;
    @Mock
    protected Repository mockRepository;
    @Mock
    protected Workspace mockWorkspace;
    @Mock
    protected Resource mockSubject;
    @Mock
    protected Node mockNode;
    @Mock
    protected NodeType mockNodeType;
    @Mock
    protected ValueFactory mockValueFactory;
    protected UriInfo uriInfo;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        this.uriInfo = GraphSubjectsTest.getUriInfoImpl(this.testPath);
        Mockito.when((Object)this.mockSession.getValueFactory()).thenReturn((Object)this.mockValueFactory);
        Mockito.when((Object)this.mockSession.getRepository()).thenReturn((Object)this.mockRepository);
        this.testObj = this.getTestObj();
    }

    protected abstract GraphSubjects getTestObj();

    protected static UriInfo getUriInfoImpl(String path) {
        UriInfo ui = (UriInfo)Mockito.mock(UriInfo.class);
        UriBuilderImpl ub = new UriBuilderImpl();
        ub.scheme("http");
        ub.host("localhost");
        ub.port(8080);
        ub.path("/fcrepo");
        UriBuilderImpl rb = new UriBuilderImpl();
        rb.scheme("http");
        rb.host("localhost");
        rb.port(8080);
        rb.path("/fcrepo/rest" + path);
        Mockito.when((Object)ui.getRequestUri()).thenReturn((Object)URI.create("http://localhost:8080/fcrepo/rest" + path));
        Mockito.when((Object)ui.getBaseUri()).thenReturn((Object)URI.create("http://localhost:8080/fcrepo"));
        Mockito.when((Object)ui.getBaseUriBuilder()).thenReturn((Object)ub);
        Mockito.when((Object)ui.getAbsolutePathBuilder()).thenReturn((Object)rb);
        return ui;
    }

    @Path(value="/rest/{path}")
    protected class MockNodeController {
        protected MockNodeController() {
        }
    }
}

