/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.modify.GraphStoreBasic;
import com.hp.hpl.jena.update.GraphStore;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.WebApplicationException;
import org.fcrepo.http.commons.domain.RDFMediaType;
import org.fcrepo.http.commons.responses.GraphStoreStreamingOutput;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphStreamingOutputTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphStreamingOutputTest.class);

    @Test
    public void testStuff() throws WebApplicationException, IOException {
        GraphStoreBasic graphStore = new GraphStoreBasic(DatasetFactory.create((Model)ModelFactory.createDefaultModel()));
        GraphMem g = new GraphMem();
        g.add(new Triple(NodeFactory.createURI((String)"test:subject"), NodeFactory.createURI((String)"test:predicate"), NodeFactory.createURI((String)"test:object")));
        graphStore.setDefaultGraph((Graph)g);
        GraphStoreStreamingOutput test = new GraphStoreStreamingOutput((GraphStore)graphStore, RDFMediaType.NTRIPLES_TYPE);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            test.write((OutputStream)out);
            String serialized = out.toString();
            LOGGER.debug("Created serialized RDF: \n {}", (Object)serialized);
            Assert.assertTrue((String)"Couldn't find test subject!", (boolean)serialized.contains("test:subject"));
            Assert.assertTrue((String)"Couldn't find test predicate!", (boolean)serialized.contains("test:predicate"));
            Assert.assertTrue((String)"Couldn't find test object!", (boolean)serialized.contains("test:object"));
        }
    }
}

