/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.google.common.collect.ImmutableMap;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.core.Quad;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.http.commons.responses.ViewHelpers;
import org.fcrepo.http.commons.test.util.TestHelpers;
import org.fcrepo.kernel.RdfLexicon;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ViewHelpersTest {
    private ViewHelpers testObj;

    @Before
    public void setUp() {
        this.testObj = ViewHelpers.getInstance();
    }

    @Test
    public void shouldConvertAUriToNodeBreadcrumbs() {
        UriInfo mockUriInfo = TestHelpers.getUriInfoImpl();
        Map nodeBreadcrumbs = this.testObj.getNodeBreadcrumbs(mockUriInfo, ResourceFactory.createResource((String)"http://localhost/fcrepo/a/b/c").asNode());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"http://localhost/fcrepo/a", (Object)"a", (Object)"http://localhost/fcrepo/a/b", (Object)"b", (Object)"http://localhost/fcrepo/a/b/c", (Object)"c"), (Object)nodeBreadcrumbs);
    }

    @Test
    public void shouldRefuseToConvertAForeignUriToNodeBreadcrumbs() {
        UriInfo mockUriInfo = TestHelpers.getUriInfoImpl();
        Map nodeBreadcrumbs = this.testObj.getNodeBreadcrumbs(mockUriInfo, ResourceFactory.createResource((String)"http://somewhere/else/a/b/c").asNode());
        Assert.assertTrue((boolean)nodeBreadcrumbs.isEmpty());
    }

    @Test
    public void testIsFrozenNode() {
        DatasetGraph mem = DatasetGraphFactory.createMem();
        mem.add(NodeFactory.createAnon(), NodeFactory.createURI((String)"a/b/c"), RdfLexicon.HAS_PRIMARY_TYPE.asNode(), NodeFactory.createLiteral((String)"nt:frozenNode"));
        Assert.assertTrue((String)"Node is a frozen node.", (boolean)this.testObj.isFrozenNode(mem, NodeFactory.createURI((String)"a/b/c")));
    }

    @Test
    public void testIsNotFrozenNode() {
        DatasetGraph mem = DatasetGraphFactory.createMem();
        mem.add(NodeFactory.createAnon(), NodeFactory.createURI((String)"a/b/c"), RdfLexicon.HAS_PRIMARY_TYPE.asNode(), NodeFactory.createLiteral((String)"nt:file"));
        Assert.assertFalse((String)"Node is not a frozen node.", (boolean)this.testObj.isFrozenNode(mem, NodeFactory.createURI((String)"a/b/c")));
    }

    @Test
    public void testGetLabeledVersion() {
        DatasetGraph mem = DatasetGraphFactory.createMem();
        String label = "testLabel";
        mem.add(NodeFactory.createAnon(), NodeFactory.createURI((String)"a/b/c"), RdfLexicon.HAS_VERSION_LABEL.asNode(), NodeFactory.createLiteral((String)"testLabel"));
        Assert.assertEquals((String)"Version label should be available.", (Object)"testLabel", (Object)this.testObj.getVersionLabel(mem, NodeFactory.createURI((String)"a/b/c"), ""));
    }

    @Test
    public void testGetUnlabeledVersion() {
        DatasetGraph mem = DatasetGraphFactory.createMem();
        Assert.assertEquals((String)"Default version label should be used.", (Object)this.testObj.getVersionLabel(mem, NodeFactory.createURI((String)"a/b/c"), "default"), (Object)"default");
    }

    @Test
    public void testGetVersionDate() {
        DatasetGraph mem = DatasetGraphFactory.createMem();
        String date = new Date().toString();
        mem.add(NodeFactory.createAnon(), NodeFactory.createURI((String)"a/b/c"), RdfLexicon.LAST_MODIFIED_DATE.asNode(), NodeFactory.createLiteral((String)date));
        Assert.assertEquals((String)"Date should be available.", (Object)date, (Object)this.testObj.getVersionDate(mem, NodeFactory.createURI((String)"a/b/c")));
    }

    @Test
    public void testGetMissingVersionDate() {
        DatasetGraph mem = DatasetGraphFactory.createMem();
        Assert.assertNull((String)"Date should not be available.", (Object)this.testObj.getVersionDate(mem, NodeFactory.createURI((String)"a/b/c")));
    }

    @Test
    public void shouldTryToExtractDublinCoreTitleFromNode() {
        DatasetGraph mem = DatasetGraphFactory.createMem();
        mem.add(NodeFactory.createAnon(), NodeFactory.createURI((String)"a/b/c"), RdfLexicon.DC_TITLE.asNode(), NodeFactory.createLiteral((String)"abc"));
        Assert.assertEquals((Object)"abc", (Object)this.testObj.getObjectTitle(mem, NodeFactory.createURI((String)"a/b/c")));
    }

    @Test
    public void shouldUseTheObjectUriIfATitleIsNotAvailable() {
        DatasetGraph mem = DatasetGraphFactory.createMem();
        Assert.assertEquals((Object)"a/b/c", (Object)this.testObj.getObjectTitle(mem, NodeFactory.createURI((String)"a/b/c")));
    }

    @Test
    public void shouldUsetheBNodeIdIfItIsABNode() {
        DatasetGraph mem = DatasetGraphFactory.createMem();
        Node anon = NodeFactory.createAnon();
        Assert.assertEquals((Object)anon.getBlankNodeLabel(), (Object)this.testObj.getObjectTitle(mem, anon));
    }

    @Test
    public void shouldJustUseTheStringIfItIsALiteral() {
        DatasetGraph mem = DatasetGraphFactory.createMem();
        Node lit = NodeFactory.createLiteral((String)"xyz");
        Assert.assertEquals((Object)"\"xyz\"", (Object)this.testObj.getObjectTitle(mem, lit));
    }

    @Test
    public void shouldGetSerializationFormat() {
        Node subject = NodeFactory.createURI((String)"subject/fcr:export?format=jcr/xml");
        DatasetGraph mem = DatasetGraphFactory.createMem();
        mem.add(NodeFactory.createAnon(), subject, NodeFactory.createLiteral((String)"predicate"), NodeFactory.createLiteral((String)"abc"));
        Assert.assertEquals((Object)"jcr/xml", (Object)this.testObj.getObjectTitle(mem, subject));
    }

    @Test
    public void shouldConvertRdfObjectsToStrings() {
        DatasetGraph mem = DatasetGraphFactory.createMem();
        mem.add(NodeFactory.createAnon(), NodeFactory.createURI((String)"subject"), NodeFactory.createURI((String)"a/b/c"), NodeFactory.createLiteral((String)"abc"));
        mem.add(NodeFactory.createAnon(), NodeFactory.createURI((String)"subject"), NodeFactory.createURI((String)"a-numeric-type"), ResourceFactory.createTypedLiteral((Object)0).asNode());
        mem.add(NodeFactory.createAnon(), NodeFactory.createURI((String)"subject"), NodeFactory.createURI((String)"an-empty-string"), NodeFactory.createLiteral((String)""));
        mem.add(NodeFactory.createAnon(), NodeFactory.createURI((String)"subject"), NodeFactory.createURI((String)"a-uri"), NodeFactory.createURI((String)"some-uri"));
        Assert.assertEquals((Object)"abc", (Object)this.testObj.getObjectsAsString(mem, NodeFactory.createURI((String)"subject"), ResourceFactory.createResource((String)"a/b/c"), true));
        Assert.assertEquals((Object)"0", (Object)this.testObj.getObjectsAsString(mem, NodeFactory.createURI((String)"subject"), ResourceFactory.createResource((String)"a-numeric-type"), true));
        Assert.assertEquals((Object)"<empty>", (Object)this.testObj.getObjectsAsString(mem, NodeFactory.createURI((String)"subject"), ResourceFactory.createResource((String)"an-empty-string"), true));
        Assert.assertEquals((Object)"&lt;<a href=\"some-uri\">some-uri</a>&gt;", (Object)this.testObj.getObjectsAsString(mem, NodeFactory.createURI((String)"subject"), ResourceFactory.createResource((String)"a-uri"), true));
        Assert.assertEquals((Object)"some-uri", (Object)this.testObj.getObjectsAsString(mem, NodeFactory.createURI((String)"subject"), ResourceFactory.createResource((String)"a-uri"), false));
        Assert.assertEquals((Object)"", (Object)this.testObj.getObjectsAsString(mem, NodeFactory.createURI((String)"subject"), ResourceFactory.createResource((String)"a-nonexistent-uri"), true));
    }

    @Test
    public void shouldExtractNamespaceAndPrefix() {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("prefix", "namespace");
        Assert.assertEquals((Object)"prefix:", (Object)this.testObj.getNamespacePrefix((PrefixMapping)model, "namespace", false));
        Assert.assertEquals((Object)"some-other-namespace", (Object)this.testObj.getNamespacePrefix((PrefixMapping)model, "some-other-namespace", false));
    }

    @Test
    public void shouldSortTriplesForDisplay() {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("prefix", "namespace");
        Property propertyA = model.createProperty("namespace", "a");
        Property propertyB = model.createProperty("namespace", "b");
        Property propertyC = model.createProperty("c");
        Literal literalA = model.createLiteral("a");
        Literal literalB = model.createLiteral("b");
        Resource resourceB = model.createResource("b");
        model.add(resourceB, propertyA, (RDFNode)literalA);
        Resource a = model.createResource("a");
        model.add(a, propertyC, (RDFNode)literalA);
        model.add(a, propertyB, (RDFNode)literalA);
        model.add(a, propertyA, (RDFNode)literalA);
        model.add(a, propertyA, (RDFNode)literalB);
        Iterator iterator = DatasetFactory.create((Model)model).asDatasetGraph().find();
        List sortedTriples = this.testObj.getSortedTriples(model, iterator);
        ((Quad)sortedTriples.get(0)).matches(Node.ANY, a.asNode(), propertyA.asNode(), literalA.asNode());
        ((Quad)sortedTriples.get(1)).matches(Node.ANY, a.asNode(), propertyA.asNode(), literalB.asNode());
        ((Quad)sortedTriples.get(2)).matches(Node.ANY, a.asNode(), propertyB.asNode(), literalA.asNode());
        ((Quad)sortedTriples.get(3)).matches(Node.ANY, a.asNode(), propertyC.asNode(), literalA.asNode());
        ((Quad)sortedTriples.get(4)).matches(Node.ANY, resourceB.asNode(), propertyC.asNode(), literalA.asNode());
    }

    @Test
    public void shouldConvertPrefixMappingToSparqlUpdatePrefixPreamble() {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("prefix", "namespace");
        String prefixPreamble = this.testObj.getPrefixPreamble((PrefixMapping)model);
        Assert.assertEquals((Object)"PREFIX prefix: <namespace>\n\n", (Object)prefixPreamble);
    }

    @Test
    public void shouldConvertRdfResourcesToNodes() {
        Assert.assertEquals((Object)RdfLexicon.CREATED_BY.asNode(), (Object)this.testObj.asNode((Resource)RdfLexicon.CREATED_BY));
    }

    @Test
    public void shouldConvertStringLiteralsToNodes() {
        String uri = "fedora:resource";
        Literal URIRES = ResourceFactory.createPlainLiteral((String)"fedora:resource");
        Assert.assertEquals((Object)URIRES.asNode(), (Object)this.testObj.asLiteralStringNode("fedora:resource"));
    }
}

