/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.session;

import java.security.Principal;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.fcrepo.http.commons.session.SessionFactory;
import org.fcrepo.kernel.Transaction;
import org.fcrepo.kernel.services.TransactionService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.api.ServletCredentials;

public class SessionFactoryTest {
    SessionFactory testObj;
    @Mock
    private Session txSession;
    @Mock
    private Session mockSession;
    @Mock
    private Repository mockRepo;
    @Mock
    private TransactionService mockTxService;
    @Mock
    private Transaction mockTx;
    @Mock
    private HttpServletRequest mockRequest;
    @Mock
    private Principal mockUser;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new SessionFactory(this.mockRepo, this.mockTxService);
        this.testObj.init();
    }

    @Test
    public void testGetSessionWithNullPath() throws LoginException, RepositoryException {
        Mockito.when((Object)this.mockRequest.getPathInfo()).thenReturn(null);
        this.testObj.getSession(this.mockRequest);
        ((Repository)Mockito.verify((Object)this.mockRepo)).login((Credentials)Matchers.any(ServletCredentials.class));
    }

    @Test
    public void testGetSessionAuthenticated() throws LoginException, RepositoryException {
        Mockito.when((Object)this.mockRequest.getUserPrincipal()).thenReturn((Object)this.mockUser);
        HttpServletRequest mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockRequest.getPathInfo()).thenReturn((Object)"/some/path");
        this.testObj.getSession(mockRequest);
        ((Repository)Mockito.verify((Object)this.mockRepo)).login((Credentials)Matchers.any(Credentials.class));
    }

    @Test
    public void testGetSessionUnauthenticated() throws LoginException, RepositoryException {
        this.testObj.getInternalSession();
        ((Repository)Mockito.verify((Object)this.mockRepo)).login();
    }

    @Test
    public void testGetSessionWithWorkspace() throws LoginException, RepositoryException {
        Mockito.when((Object)this.mockRequest.getPathInfo()).thenReturn((Object)"/workspace:some-workspace/some/path");
        this.testObj.getSession(this.mockRequest);
        ((Repository)Mockito.verify((Object)this.mockRepo)).login((Credentials)Matchers.any(ServletCredentials.class), (String)Matchers.eq((Object)"some-workspace"));
    }

    @Test
    public void testGetSessionWithTransaction() throws LoginException, RepositoryException {
        Mockito.when((Object)this.mockRequest.getPathInfo()).thenReturn((Object)"/tx:123/some/path");
        Mockito.when((Object)this.mockTx.getSession()).thenReturn(Mockito.mock(Session.class));
        Mockito.when((Object)this.mockTxService.getTransaction("123")).thenReturn((Object)this.mockTx);
        Session session = this.testObj.getSession(this.mockRequest);
        Assert.assertEquals((Object)this.mockTx.getSession(), (Object)session);
    }

    @Test
    public void testGetAuthenticatedSessionWithWorkspace() throws LoginException, RepositoryException {
        Mockito.when((Object)this.mockRequest.getUserPrincipal()).thenReturn((Object)this.mockUser);
        Mockito.when((Object)this.mockRequest.getPathInfo()).thenReturn((Object)"/workspace:some-workspace/some/path");
        this.testObj.getSession(this.mockRequest);
        ((Repository)Mockito.verify((Object)this.mockRepo)).login((Credentials)Matchers.any(Credentials.class), (String)Matchers.eq((Object)"some-workspace"));
    }

    @Test
    public void testGetAuthenticatedSessionWithTransaction() throws RepositoryException {
        Mockito.when((Object)this.mockRequest.getUserPrincipal()).thenReturn((Object)this.mockUser);
        Mockito.when((Object)this.mockRequest.getPathInfo()).thenReturn((Object)"/tx:123/some/path");
        Mockito.when((Object)this.mockTx.getSession()).thenReturn((Object)this.txSession);
        Mockito.when((Object)this.mockTx.isAssociatedWithUser(Mockito.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.mockTxService.isAssociatedWithUser(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.mockTxService.getTransaction("123")).thenReturn((Object)this.mockTx);
        Session session = this.testObj.getSession(this.mockRequest);
        Assert.assertEquals((Object)this.txSession, (Object)session);
        ((Transaction)Mockito.verify((Object)this.mockTx)).getSession();
    }
}

