/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons;

import com.google.common.eventbus.EventBus;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.http.commons.api.rdf.HttpTripleUtil;
import org.fcrepo.http.commons.session.SessionFactory;
import org.fcrepo.kernel.FedoraResource;
import org.fcrepo.kernel.identifiers.PidMinter;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.fcrepo.kernel.services.DatastreamService;
import org.fcrepo.kernel.services.NodeService;
import org.fcrepo.kernel.services.ObjectService;
import org.fcrepo.kernel.services.RepositoryService;
import org.fcrepo.kernel.services.VersionService;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.modeshape.jcr.api.JcrTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractResource.class);
    @Context
    protected UriInfo uriInfo;
    @Autowired
    protected SessionFactory sessions;
    @Autowired
    protected NodeService nodeService;
    @Autowired
    protected ObjectService objectService;
    @Autowired
    protected DatastreamService datastreamService;
    @Autowired
    protected VersionService versionService;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired(required=false)
    private HttpTripleUtil httpTripleUtil;
    @Autowired(required=false)
    protected EventBus eventBus;
    @Autowired
    protected PidMinter pidMinter;
    protected static final JcrTools jcrTools = new JcrTools(true);

    public static final String toPath(List<PathSegment> paths) {
        StringBuilder result = new StringBuilder();
        LOGGER.trace("converting URI path to JCR path: {}", paths);
        int i = 0;
        for (PathSegment path : paths) {
            String p = path.getPath();
            if (p.equals("")) {
                LOGGER.trace("Ignoring empty segment {}", (Object)p);
                continue;
            }
            if (i == 0 && (p.startsWith("tx:") || p.startsWith("workspace:"))) {
                LOGGER.trace("Ignoring internal segment {}", (Object)p);
                ++i;
                continue;
            }
            LOGGER.trace("Adding segment {}", (Object)p);
            if (!p.startsWith("[")) {
                result.append('/');
            }
            result.append(p);
            ++i;
        }
        String path = result.toString();
        if (path.isEmpty()) {
            return "/";
        }
        return path;
    }

    protected void addResponseInformationToStream(FedoraResource resource, RdfStream dataset, UriInfo uriInfo, GraphSubjects subjects) throws RepositoryException {
        if (this.httpTripleUtil != null) {
            this.httpTripleUtil.addHttpComponentModelsForResourceToStream(dataset, resource, uriInfo, subjects);
        }
    }
}

