/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.session;

import com.google.common.base.Preconditions;
import com.sun.jersey.spi.inject.Injectable;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.fcrepo.http.commons.session.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectableSession
implements Injectable<Session> {
    private SessionFactory sessionFactory;
    private HttpServletRequest request;
    private static final Logger LOGGER = LoggerFactory.getLogger(InjectableSession.class);

    public InjectableSession(SessionFactory sessionFactory, HttpServletRequest request) {
        Preconditions.checkNotNull((Object)sessionFactory, (Object)"SessionFactory cannot be null!");
        Preconditions.checkNotNull((Object)request, (Object)"HttpServletRequest cannot be null!");
        LOGGER.debug("Initializing an InjectableSession with SessionFactory {}.", (Object)sessionFactory);
        this.sessionFactory = sessionFactory;
        this.request = request;
    }

    public Session getValue() {
        return this.sessionFactory.getSession(this.request);
    }
}

