/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.session;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.security.Principal;
import javax.annotation.PostConstruct;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.fcrepo.kernel.Transaction;
import org.fcrepo.kernel.exception.TransactionMissingException;
import org.fcrepo.kernel.services.TransactionService;
import org.modeshape.jcr.api.ServletCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SessionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionFactory.class);
    @Autowired
    private Repository repo;
    @Autowired
    private TransactionService transactionService;

    public SessionFactory() {
    }

    public SessionFactory(Repository repo, TransactionService transactionService) {
        this.repo = repo;
        this.transactionService = transactionService;
    }

    @PostConstruct
    public void init() {
        Preconditions.checkNotNull((Object)this.repo, (Object)"SessionFactory requires a Repository instance!");
    }

    public Session getInternalSession() throws RepositoryException {
        return this.repo.login();
    }

    public Session getInternalSession(String workspace) throws RepositoryException {
        return this.repo.login(workspace);
    }

    public Session getSession(HttpServletRequest servletRequest) {
        try {
            Session session;
            ServletCredentials creds = new ServletCredentials(servletRequest);
            Transaction transaction = this.getEmbeddedTransaction(servletRequest);
            Principal userPrincipal = servletRequest.getUserPrincipal();
            boolean isUserAuthorizedForTransaction = false;
            if (transaction != null) {
                if (userPrincipal != null) {
                    String userName = userPrincipal.getName();
                    isUserAuthorizedForTransaction = this.transactionService.isAssociatedWithUser(transaction.getId(), userName);
                } else {
                    isUserAuthorizedForTransaction = true;
                }
            }
            if (transaction != null && isUserAuthorizedForTransaction) {
                LOGGER.debug("Returning a session in the transaction {}", (Object)transaction);
                session = transaction.getSession();
            } else {
                String workspace = this.getEmbeddedWorkspace(servletRequest);
                if (workspace != null) {
                    LOGGER.debug("Returning an authenticated session in the workspace {}", (Object)workspace);
                    session = this.repo.login((Credentials)creds, workspace);
                } else {
                    LOGGER.debug("Returning an authenticated session in the default workspace");
                    session = this.repo.login((Credentials)creds);
                }
            }
            return session;
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private String getEmbeddedWorkspace(HttpServletRequest request) {
        String requestPath = request.getPathInfo();
        if (requestPath == null) {
            return null;
        }
        String[] part = requestPath.split("/");
        if (part.length > 1 && part[1].startsWith("workspace:")) {
            return part[1].substring("workspace:".length());
        }
        return null;
    }

    private Transaction getEmbeddedTransaction(HttpServletRequest servletRequest) throws TransactionMissingException {
        String requestPath = servletRequest.getPathInfo();
        if (requestPath == null) {
            return null;
        }
        String[] part = requestPath.split("/");
        if (part.length > 1 && part[1].startsWith("tx:")) {
            String txid = part[1].substring("tx:".length());
            return this.transactionService.getTransaction(txid);
        }
        return null;
    }
}

