/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons;

import com.google.common.eventbus.EventBus;
import java.util.Date;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.http.commons.api.rdf.HttpTripleUtil;
import org.fcrepo.http.commons.session.SessionFactory;
import org.fcrepo.kernel.FedoraResource;
import org.fcrepo.kernel.identifiers.PidMinter;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.fcrepo.kernel.services.DatastreamService;
import org.fcrepo.kernel.services.LockService;
import org.fcrepo.kernel.services.NodeService;
import org.fcrepo.kernel.services.ObjectService;
import org.fcrepo.kernel.services.RepositoryService;
import org.fcrepo.kernel.services.VersionService;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.modeshape.jcr.api.JcrTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractResource.class);
    @Context
    protected UriInfo uriInfo;
    @Autowired
    protected SessionFactory sessions;
    @Autowired
    protected NodeService nodeService;
    @Autowired
    protected ObjectService objectService;
    @Autowired
    protected DatastreamService datastreamService;
    @Autowired
    protected VersionService versionService;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected LockService lockService;
    @Autowired(required=false)
    private HttpTripleUtil httpTripleUtil;
    @Autowired(required=false)
    protected EventBus eventBus;
    @Autowired
    protected PidMinter pidMinter;
    protected static final JcrTools jcrTools = new JcrTools(true);

    public static final String toPath(List<PathSegment> paths) {
        StringBuilder result = new StringBuilder();
        LOGGER.trace("converting URI path to JCR path: {}", paths);
        int i = 0;
        for (PathSegment path : paths) {
            String p = path.getPath();
            if (p.equals("")) {
                LOGGER.trace("Ignoring empty segment {}", (Object)p);
                continue;
            }
            if (i == 0 && (p.startsWith("tx:") || p.startsWith("workspace:"))) {
                LOGGER.trace("Ignoring internal segment {}", (Object)p);
                ++i;
                continue;
            }
            LOGGER.trace("Adding segment {}", (Object)p);
            if (!p.startsWith("[")) {
                result.append('/');
            }
            result.append(p);
            ++i;
        }
        String path = result.toString();
        if (path.isEmpty()) {
            return "/";
        }
        return path;
    }

    protected static void checkCacheControlHeaders(Request request, HttpServletResponse servletResponse, FedoraResource resource) throws RepositoryException {
        Response.ResponseBuilder builder;
        EntityTag etag = new EntityTag(resource.getEtagValue());
        Date date = resource.getLastModifiedDate();
        Date roundedDate = new Date();
        if (date != null) {
            roundedDate.setTime(date.getTime() - date.getTime() % 1000L);
        }
        if ((builder = request.evaluatePreconditions(roundedDate, etag)) != null) {
            CacheControl cc = new CacheControl();
            cc.setMaxAge(0);
            cc.setMustRevalidate(true);
            throw new WebApplicationException(builder.cacheControl(cc).lastModified(date).tag(etag).build());
        }
        AbstractResource.addCacheControlHeaders(servletResponse, resource);
    }

    protected static void addCacheControlHeaders(HttpServletResponse servletResponse, FedoraResource resource) throws RepositoryException {
        EntityTag etag = new EntityTag(resource.getEtagValue());
        Date date = resource.getLastModifiedDate();
        if (!etag.getValue().isEmpty()) {
            servletResponse.addHeader("ETag", etag.toString());
        }
        if (date != null) {
            servletResponse.addDateHeader("Last-Modified", date.getTime());
        }
    }

    protected static void evaluateRequestPreconditions(Request request, FedoraResource resource) throws RepositoryException {
        Response.ResponseBuilder builder;
        EntityTag etag = new EntityTag(resource.getEtagValue());
        Date date = resource.getLastModifiedDate();
        Date roundedDate = new Date();
        if (date != null) {
            roundedDate.setTime(date.getTime() - date.getTime() % 1000L);
        }
        if ((builder = request.evaluatePreconditions(roundedDate, etag)) != null) {
            throw new WebApplicationException(builder.build());
        }
    }

    protected void addResponseInformationToStream(FedoraResource resource, RdfStream dataset, UriInfo uriInfo, IdentifierTranslator subjects) throws RepositoryException {
        if (this.httpTripleUtil != null) {
            this.httpTripleUtil.addHttpComponentModelsForResourceToStream(dataset, resource, uriInfo, subjects);
        }
    }
}

