/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.api.rdf;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.http.commons.api.rdf.UriAwareResourceModelFactory;
import org.fcrepo.kernel.FedoraResource;
import org.fcrepo.kernel.FedoraResourceImpl;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class HttpTripleUtil
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpTripleUtil.class);
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void addHttpComponentModelsForResource(Dataset dataset, FedoraResourceImpl resource, UriInfo uriInfo, IdentifierTranslator graphSubjects) throws RepositoryException {
        LOGGER.debug("Adding additional HTTP context triples to dataset");
        for (Map.Entry<String, UriAwareResourceModelFactory> e : this.getUriAwareTripleFactories().entrySet()) {
            String beanName = e.getKey();
            UriAwareResourceModelFactory uriAwareResourceModelFactory = e.getValue();
            LOGGER.debug("Adding response information using {}", (Object)beanName);
            Model m = uriAwareResourceModelFactory.createModelForResource((FedoraResource)resource, uriInfo, graphSubjects);
            dataset.addNamedModel(beanName, m);
        }
    }

    public void addHttpComponentModelsForResourceToStream(RdfStream rdfStream, FedoraResource resource, UriInfo uriInfo, IdentifierTranslator graphSubjects) throws RepositoryException {
        LOGGER.debug("Adding additional HTTP context triples to dataset");
        for (Map.Entry<String, UriAwareResourceModelFactory> e : this.getUriAwareTripleFactories().entrySet()) {
            String beanName = e.getKey();
            UriAwareResourceModelFactory uriAwareResourceModelFactory = e.getValue();
            LOGGER.debug("Adding response information using: {}", (Object)beanName);
            Model m = uriAwareResourceModelFactory.createModelForResource(resource, uriInfo, graphSubjects);
            rdfStream.concat((Iterator)RdfStream.fromModel((Model)m));
        }
    }

    private Map<String, UriAwareResourceModelFactory> getUriAwareTripleFactories() {
        return this.applicationContext.getBeansOfType(UriAwareResourceModelFactory.class);
    }
}

