/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.domain;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.sun.jersey.core.header.reader.HttpHeaderReader;
import java.text.ParseException;
import java.util.List;
import org.fcrepo.http.commons.domain.PreferTag;

public class Prefer {
    private final List<PreferTag> preferTags;
    private static final HttpHeaderReader.ListElementCreator<PreferTag> PREFER_CREATOR = new HttpHeaderReader.ListElementCreator<PreferTag>(){

        public PreferTag create(HttpHeaderReader reader) throws ParseException {
            return new PreferTag(reader);
        }
    };

    public Prefer(String inputValue) throws ParseException {
        this.preferTags = HttpHeaderReader.readList(PREFER_CREATOR, (String)inputValue);
    }

    public Boolean hasReturn() {
        return Iterators.any(this.preferTags.iterator(), Prefer.getPreferTag("return"));
    }

    public PreferTag getReturn() {
        Optional aReturn = Iterators.tryFind(this.preferTags.iterator(), Prefer.getPreferTag("return"));
        if (aReturn.isPresent()) {
            return (PreferTag)aReturn.get();
        }
        return new PreferTag("");
    }

    private static Predicate<PreferTag> getPreferTag(final String tagName) {
        return new Predicate<PreferTag>(){

            public boolean apply(PreferTag tag) {
                return tag.getTag().equals(tagName);
            }
        };
    }
}

