/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.domain;

import com.sun.jersey.core.header.InBoundHeaders;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.core.MultivaluedMap;
import org.fcrepo.http.commons.domain.ContentLocationMessageBodyReader;
import org.fcrepo.kernel.services.ExternalContentService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class ContentLocationMessageBodyReaderTest {
    private ContentLocationMessageBodyReader testObj;
    @Mock
    private InputStream mockInputStream;
    @Mock
    private ExternalContentService mockContentService;

    @Before
    public void setUp() throws URISyntaxException, IOException {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new ContentLocationMessageBodyReader();
        this.testObj.setContentService(this.mockContentService);
    }

    @Test
    public void testReadFromURI() throws Exception {
        InBoundHeaders headers = new InBoundHeaders();
        headers.putSingle("Content-Location", (Object)"http://localhost:8080/xyz");
        Mockito.when((Object)this.mockContentService.retrieveExternalContent(new URI("http://localhost:8080/xyz"))).thenReturn((Object)this.mockInputStream);
        InputStream actual = this.testObj.readFrom(InputStream.class, null, null, null, (MultivaluedMap)headers, null);
        Assert.assertEquals((Object)this.mockInputStream, (Object)actual);
    }

    @Test
    public void testReadFromRequestBody() throws Exception {
        InBoundHeaders headers = new InBoundHeaders();
        InputStream actual = this.testObj.readFrom(InputStream.class, null, null, null, (MultivaluedMap)headers, this.mockInputStream);
        Assert.assertEquals((Object)this.mockInputStream, (Object)actual);
    }
}

