/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.google.common.collect.ImmutableMap;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.fcrepo.http.commons.responses.BaseHtmlProvider;
import org.fcrepo.http.commons.responses.StreamingBaseHtmlProvider;
import org.fcrepo.http.commons.test.util.TestHelpers;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class StreamingBaseHtmlProviderTest {
    private StreamingBaseHtmlProvider testProvider = new StreamingBaseHtmlProvider();
    @Mock
    private Session mockSession;
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private NamespaceRegistry mockNamespaceRegistry;
    @Mock
    private BaseHtmlProvider mockBaseHtmlProvider;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getNamespaceRegistry()).thenReturn((Object)this.mockNamespaceRegistry);
        Mockito.when((Object)this.mockNamespaceRegistry.getPrefixes()).thenReturn((Object)new String[]{"pr"});
        Mockito.when((Object)this.mockNamespaceRegistry.getURI("pr")).thenReturn((Object)"nsuri");
        TestHelpers.setField(this.testProvider, "delegate", this.mockBaseHtmlProvider);
    }

    @Test
    public void testGetSize() {
        Assert.assertEquals((long)-1L, (long)this.testProvider.getSize(null, null, null, null, null));
    }

    @Test
    public void testIsWriteable() {
        Mockito.when((Object)this.mockBaseHtmlProvider.isWriteable(Dataset.class, null, null, MediaType.valueOf((String)"text/something-like-html"))).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.testProvider.isWriteable(RdfStream.class, null, null, MediaType.valueOf((String)"text/something-like-html")));
    }

    @Test
    public void testWriteTo() throws WebApplicationException, IllegalArgumentException, IOException {
        Triple t = Triple.create((Node)NodeFactory.createURI((String)"info:test"), (Node)NodeFactory.createURI((String)"property:test"), (Node)NodeFactory.createURI((String)"info:test"));
        RdfStream rdfStream = new RdfStream(t).session(this.mockSession);
        try (ByteArrayOutputStream entityStream = new ByteArrayOutputStream();){
            this.testProvider.writeTo(rdfStream, RdfStream.class, null, null, MediaType.valueOf((String)"text/html"), null, (OutputStream)entityStream);
        }
        ArgumentCaptor argument = ArgumentCaptor.forClass(Dataset.class);
        ((BaseHtmlProvider)Mockito.verify((Object)this.mockBaseHtmlProvider)).writeTo((Dataset)argument.capture(), (Class)Matchers.eq(RdfStream.class), (Type)Matchers.eq((Object)null), (Annotation[])Matchers.eq((Object)null), (MediaType)Matchers.eq((Object)MediaType.valueOf((String)"text/html")), (MultivaluedMap)Matchers.eq((Object)null), (OutputStream)Matchers.any(OutputStream.class));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"pr", (Object)"nsuri"), (Object)((Dataset)argument.getValue()).getDefaultModel().getNsPrefixMap());
    }
}

