/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.hp.hpl.jena.query.Dataset;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.jena.riot.WebContent;
import org.fcrepo.http.commons.responses.GraphStoreStreamingOutput;
import org.fcrepo.http.commons.responses.RdfSerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Provider
@Component
@Produces(value={"text/turtle", "text/rdf+n3", "text/n3", "application/rdf+xml", "application/n-triples", "application/xml", "text/plain", "application/x-turtle", "application/ld+json"})
public class RdfProvider
implements MessageBodyWriter<Dataset> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RdfProvider.class);

    public void writeTo(Dataset rdf, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        LOGGER.debug("Writing a response for: {} with MIMEtype: {}", (Object)rdf, (Object)mediaType);
        httpHeaders.put((Object)"Content-type", Collections.singletonList(mediaType.toString()));
        RdfSerializationUtils.setCachingHeaders(httpHeaders, rdf);
        new GraphStoreStreamingOutput(rdf, mediaType).write(entityStream);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        Boolean appropriateMimeType = WebContent.contentTypeToLang((String)mediaType.toString()) != null;
        return appropriateMimeType != false && Dataset.class.isAssignableFrom(type);
    }

    public long getSize(Dataset rdf, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }
}

