/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.google.common.collect.ImmutableList;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.util.Context;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import javax.ws.rs.core.MultivaluedMap;
import org.fcrepo.kernel.impl.rdf.JcrRdfTools;
import org.fcrepo.kernel.rdf.GraphProperties;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfSerializationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RdfSerializationUtils.class);
    public static Node primaryTypePredicate = NodeFactory.createURI((String)(JcrRdfTools.getRDFNamespaceForJcrNamespace((String)"http://www.jcp.org/jcr/1.0") + "primaryType"));
    public static Node lastModifiedPredicate = NodeFactory.createURI((String)(JcrRdfTools.getRDFNamespaceForJcrNamespace((String)"http://www.jcp.org/jcr/1.0") + "lastModified"));
    protected static DateTimeFormatter RFC2822DATEFORMAT = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss Z").withLocale(Locale.US).withZone(DateTimeZone.forID((String)"GMT"));

    private RdfSerializationUtils() {
    }

    static String getFirstValueForPredicate(Dataset rdf, Node subject, Node predicate) {
        Iterator statements = rdf.asDatasetGraph().find(Node.ANY, subject, predicate, Node.ANY);
        if (statements.hasNext()) {
            Quad statement = (Quad)statements.next();
            LOGGER.trace("Checking statement: {}", (Object)statement);
            return statement.asTriple().getObject().getLiteral().getLexicalForm();
        }
        LOGGER.trace("No value found for predicate: {}", (Object)predicate);
        return null;
    }

    static Node getDatasetSubject(Dataset rdf) {
        Context context = rdf.getContext();
        String uri = context.getAsString(GraphProperties.URI_SYMBOL);
        LOGGER.debug("uri from context: {}", (Object)uri);
        if (uri != null) {
            return NodeFactory.createURI((String)uri);
        }
        return null;
    }

    static void setCachingHeaders(MultivaluedMap<String, Object> httpHeaders, Dataset rdf) {
        httpHeaders.put((Object)"Cache-Control", Collections.singletonList("max-age=0"));
        httpHeaders.put((Object)"Cache-Control", Collections.singletonList("must-revalidate"));
        LOGGER.trace("Attempting to discover the last-modified date of the node for the resource in question...");
        Iterator iterator = rdf.asDatasetGraph().find(Node.ANY, RdfSerializationUtils.getDatasetSubject(rdf), lastModifiedPredicate, Node.ANY);
        if (!iterator.hasNext()) {
            return;
        }
        Object dateObject = ((Quad)iterator.next()).getObject().getLiteralValue();
        if (!(dateObject instanceof XSDDateTime)) {
            LOGGER.debug("Found last-modified date, but it was not an XSDDateTime: {}", dateObject);
            return;
        }
        XSDDateTime lastModified = (XSDDateTime)dateObject;
        LOGGER.debug("Found last-modified date: {}", (Object)lastModified);
        String lastModifiedAsRdf2822 = RFC2822DATEFORMAT.print((ReadableInstant)new DateTime((Object)lastModified.asCalendar()));
        httpHeaders.put((Object)"Last-Modified", (Object)ImmutableList.of((Object)lastModifiedAsRdf2822));
    }
}

