/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.annotation.PostConstruct;
import javax.jcr.RepositoryException;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.fcrepo.http.commons.responses.BaseHtmlProvider;
import org.fcrepo.kernel.impl.rdf.SerializationUtils;
import org.fcrepo.kernel.impl.rdf.impl.NamespaceRdfContext;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@Provider
@Produces(value={"text/html", "application/xhtml+xml"})
public class StreamingBaseHtmlProvider
implements MessageBodyWriter<RdfStream>,
ApplicationContextAware {
    private BaseHtmlProvider delegate;
    private ApplicationContext applicationContext;
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamingBaseHtmlProvider.class);

    @PostConstruct
    void init() {
        this.delegate = (BaseHtmlProvider)this.applicationContext.getBean(BaseHtmlProvider.class);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!RdfStream.class.isAssignableFrom(type)) {
            return false;
        }
        LOGGER.debug("Checking to see if type: {} is serializable to mimeType: {}", (Object)type.getName(), (Object)mediaType);
        return this.delegate.isWriteable(Dataset.class, genericType, annotations, mediaType);
    }

    public long getSize(RdfStream rdfStream, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(RdfStream rdfStream, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            NamespaceRdfContext nsRdfStream = new NamespaceRdfContext(rdfStream.session());
            Dataset dataset = DatasetFactory.create((Model)rdfStream.namespaces(nsRdfStream.namespaces()).asModel());
            dataset.getContext().set(SerializationUtils.subjectKey, (Object)rdfStream.topic());
            this.delegate.writeTo(dataset, type, genericType, annotations, mediaType, httpHeaders, entityStream);
        }
        catch (RepositoryException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

