/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.session;

import com.google.common.base.Throwables;
import java.lang.reflect.Proxy;
import java.security.Principal;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.fcrepo.http.commons.session.SessionFactory;
import org.fcrepo.kernel.Transaction;
import org.fcrepo.kernel.exception.TransactionMissingException;
import org.fcrepo.kernel.impl.LockReleasingSession;
import org.fcrepo.kernel.services.TransactionService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.api.ServletCredentials;

public class SessionFactoryTest {
    SessionFactory testObj;
    @Mock
    private Session txSession;
    @Mock
    private Session mockSession;
    @Mock
    private Repository mockRepo;
    @Mock
    private TransactionService mockTxService;
    @Mock
    private Transaction mockTx;
    @Mock
    private HttpServletRequest mockRequest;
    @Mock
    private Principal mockUser;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new SessionFactory(this.mockRepo, this.mockTxService);
        this.testObj.init();
    }

    @Test
    public void testGetSessionWithNullPath() throws RepositoryException {
        Mockito.when((Object)this.mockRequest.getPathInfo()).thenReturn(null);
        Mockito.when((Object)this.mockRepo.login((Credentials)Matchers.any(Credentials.class))).thenReturn((Object)this.mockSession);
        this.testObj.getSession(this.mockRequest);
        ((Repository)Mockito.verify((Object)this.mockRepo)).login((Credentials)Matchers.any(ServletCredentials.class));
    }

    @Test
    public void testGetSessionUnauthenticated() throws RepositoryException {
        this.testObj.getInternalSession();
        ((Repository)Mockito.verify((Object)this.mockRepo)).login();
    }

    @Test
    public void testGetSessionUnauthenticatedWithWorkspace() throws RepositoryException {
        this.testObj.getInternalSession("ws");
        ((Repository)Mockito.verify((Object)this.mockRepo)).login((String)Matchers.eq((Object)"ws"));
    }

    @Test
    public void testCreateSession() throws RepositoryException {
        Mockito.when((Object)this.mockRequest.getPathInfo()).thenReturn((Object)"/some/path");
        this.testObj.createSession(this.mockRequest);
        ((Repository)Mockito.verify((Object)this.mockRepo)).login((Credentials)Matchers.any(Credentials.class));
    }

    @Test
    public void testCreateSessionWithWorkspace() throws RepositoryException {
        Mockito.when((Object)this.mockRequest.getPathInfo()).thenReturn((Object)"/workspace:some-workspace/some/path");
        this.testObj.createSession(this.mockRequest);
        ((Repository)Mockito.verify((Object)this.mockRepo)).login((Credentials)Matchers.any(ServletCredentials.class), (String)Matchers.eq((Object)"some-workspace"));
    }

    @Test
    public void testGetSessionFromTransaction() throws RepositoryException {
        Mockito.when((Object)this.mockRequest.getPathInfo()).thenReturn((Object)"/tx:123/some/path");
        Mockito.when((Object)this.mockTx.getSession()).thenReturn(Mockito.mock(Session.class));
        Mockito.when((Object)this.mockTxService.getTransaction("123", null)).thenReturn((Object)this.mockTx);
        Session session = this.testObj.getSessionFromTransaction(this.mockRequest, "123");
        Assert.assertEquals((Object)this.mockTx.getSession(), (Object)session);
    }

    @Test
    public void testGetSessionThrowException() throws RepositoryException {
        Mockito.when((Object)this.mockRequest.getPathInfo()).thenReturn((Object)"/tx:123/some/path");
        Mockito.when((Object)this.mockTx.getSession()).thenReturn(Mockito.mock(Session.class));
        Mockito.when((Object)this.mockTxService.getTransaction("123", null)).thenThrow(new Throwable[]{new TransactionMissingException("")});
        try {
            this.testObj.getSession(this.mockRequest);
        }
        catch (RuntimeException e) {
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            Assert.assertTrue((String)"TransactionMissionException expected", (boolean)(rootCause instanceof TransactionMissingException));
        }
    }

    @Test
    public void testGetAuthenticatedSessionWithTransaction() throws RepositoryException {
        String fedoraUser = "fedoraUser";
        Mockito.when((Object)this.mockRequest.getUserPrincipal()).thenReturn((Object)this.mockUser);
        Mockito.when((Object)this.mockUser.getName()).thenReturn((Object)"fedoraUser");
        Mockito.when((Object)this.mockRequest.getPathInfo()).thenReturn((Object)"/tx:123/some/path");
        Mockito.when((Object)this.mockTx.getSession()).thenReturn((Object)this.txSession);
        Mockito.when((Object)this.mockTx.isAssociatedWithUser((String)Matchers.eq((Object)"fedoraUser"))).thenReturn((Object)true);
        Mockito.when((Object)this.mockTxService.getTransaction("123", "fedoraUser")).thenReturn((Object)this.mockTx);
        Session session = this.testObj.getSession(this.mockRequest);
        Assert.assertEquals((Object)this.txSession, (Object)((LockReleasingSession)Proxy.getInvocationHandler(session)).getWrappedSession());
        ((Transaction)Mockito.verify((Object)this.mockTx)).getSession();
    }

    @Test
    public void testGetEmbeddedIdTx() {
        Mockito.when((Object)this.mockRequest.getPathInfo()).thenReturn((Object)"/tx:123/some/path");
        String txId = this.testObj.getEmbeddedId(this.mockRequest, SessionFactory.Prefix.TX);
        Assert.assertEquals((String)"txId should be 123", (Object)"123", (Object)txId);
    }

    @Test
    public void testGetEmbeddedIdWorkspace() {
        Mockito.when((Object)this.mockRequest.getPathInfo()).thenReturn((Object)"/workspace:some-workspace/some/path");
        String wsId = this.testObj.getEmbeddedId(this.mockRequest, SessionFactory.Prefix.WORKSPACE);
        Assert.assertEquals((String)"wsId should be some-workspace", (Object)"some-workspace", (Object)wsId);
    }

    @Test
    public void testGetEmbeddedIdNotExisting() {
        Mockito.when((Object)this.mockRequest.getPathInfo()).thenReturn((Object)"/some/path");
        String wsId = this.testObj.getEmbeddedId(this.mockRequest, SessionFactory.Prefix.WORKSPACE);
        Assert.assertNull((String)"expected wsId to be null", (Object)wsId);
    }

    @Test
    public void testGetEmbeddedIdWithEmptyPath() {
        Mockito.when((Object)this.mockRequest.getPathInfo()).thenReturn((Object)"");
        String wsId = this.testObj.getEmbeddedId(this.mockRequest, SessionFactory.Prefix.WORKSPACE);
        Assert.assertNull((String)"expected wsId to be null", (Object)wsId);
    }

    @Test
    public void testGetEmbeddedIdWithNullPath() {
        Mockito.when((Object)this.mockRequest.getPathInfo()).thenReturn(null);
        String wsId = this.testObj.getEmbeddedId(this.mockRequest, SessionFactory.Prefix.WORKSPACE);
        Assert.assertNull((String)"expected wsId to be null", (Object)wsId);
    }
}

