/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.api.rdf;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.Workspace;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.fcrepo.http.commons.api.rdf.SpringContextAwareIdentifierTranslator;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.identifiers.InternalIdentifierConverter;
import org.fcrepo.kernel.impl.identifiers.NamespaceConverter;
import org.fcrepo.kernel.impl.services.TransactionServiceImpl;
import org.fcrepo.kernel.impl.services.functions.GetDefaultWorkspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpIdentifierTranslator
extends SpringContextAwareIdentifierTranslator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpIdentifierTranslator.class);
    public static final String WORKSPACE_PREFIX = "workspace:";
    public static final String TX_PREFIX = "tx:";
    protected final UriBuilder uriBuilder;
    private final String basePath;
    private final int pathIx;
    private final URI context;
    private final Session session;
    private final String defaultWorkspace;
    private final Function<Repository, String> getDefaultWorkspace = new GetDefaultWorkspace();
    private final Class<?> relativeTo;
    private final UriInfo uris;
    private final boolean canonical;
    private static final List<InternalIdentifierConverter> minimalTranslationChain = Collections.singletonList(new NamespaceConverter());

    public HttpIdentifierTranslator(Session session, Class<?> relativeTo, UriInfo uris) {
        this(session, relativeTo, uris, false);
    }

    public HttpIdentifierTranslator(Session session, Class<?> relativeTo, UriInfo uris, boolean canonical) {
        this.session = session;
        this.relativeTo = relativeTo;
        this.uris = uris;
        this.canonical = canonical;
        this.context = uris.getRequestUri();
        this.uriBuilder = uris.getBaseUriBuilder().clone().path(relativeTo);
        String normalizedBasePath = this.uriBuilder.build(new Object[]{""}).toString();
        if (!normalizedBasePath.endsWith("/")) {
            normalizedBasePath = normalizedBasePath + "/";
        }
        this.basePath = normalizedBasePath;
        this.pathIx = normalizedBasePath.length() - 1;
        this.defaultWorkspace = (String)this.getDefaultWorkspace.apply((Object)session.getRepository());
        LOGGER.debug("Resolving graph subjects to a base URI of \"{}\"", (Object)normalizedBasePath);
    }

    public HttpIdentifierTranslator getCanonical(boolean canonical) {
        return new HttpIdentifierTranslator(this.session, this.relativeTo, this.uris, canonical);
    }

    public boolean isCanonical() {
        return this.canonical || TransactionServiceImpl.getCurrentTransactionId((Session)this.session) == null;
    }

    public Resource getSubject(String absPath) throws RepositoryException {
        this.resetTranslationChain();
        try {
            LOGGER.debug("Creating RDF subject from identifier: {}", (Object)URLDecoder.decode(absPath, "UTF-8"));
            return this.doForward(URLDecoder.decode(absPath, "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.warn("Required encoding (UTF-8) not supported, trying undecoded path", (Throwable)ex);
            return this.doForward(absPath);
        }
    }

    public Resource getContext() {
        return ResourceFactory.createResource((String)this.context.toString());
    }

    private static String getResourceURI(Resource subject) {
        if (!subject.isURIResource()) {
            LOGGER.debug("RDF resource {} was not a URI resource: returning null.", (Object)subject);
            return null;
        }
        return subject.getURI();
    }

    public String getPathFromSubject(Resource subject) throws RepositoryException {
        this.resetTranslationChain();
        return this.doBackward(subject);
    }

    protected String getPathFromGraphSubject(@NotNull String subjectUri) throws RepositoryException {
        String[] pathSegments;
        if (!this.isFedoraGraphSubject(subjectUri)) {
            LOGGER.debug("RDF resource {} was not a URI resource with our expected basePath {}, returning null.", (Object)subjectUri, (Object)this.basePath);
            return null;
        }
        StringBuilder pathBuilder = new StringBuilder();
        for (String segment : pathSegments = subjectUri.substring(this.pathIx).split("/")) {
            if (segment.startsWith(TX_PREFIX)) {
                if (this.canonical) continue;
                String tx = segment.substring(TX_PREFIX.length());
                String currentTxId = TransactionServiceImpl.getCurrentTransactionId((Session)this.session);
                if (currentTxId != null && tx.equals(currentTxId)) continue;
                throw new RepositoryException("Subject is not in this transaction");
            }
            if (segment.startsWith(WORKSPACE_PREFIX)) {
                String workspace = segment.substring(WORKSPACE_PREFIX.length());
                if (this.session.getWorkspace().getName().equals(workspace)) continue;
                throw new RepositoryException("Subject is not in this workspace");
            }
            if (segment.equals("fcr:content")) {
                pathBuilder.append("/");
                pathBuilder.append("jcr:content");
                continue;
            }
            if (segment.isEmpty()) continue;
            pathBuilder.append("/");
            pathBuilder.append(segment);
        }
        String absPath = pathBuilder.length() == 0 ? "/" : pathBuilder.toString();
        if (this.isValidJcrPath(absPath)) {
            return absPath;
        }
        return null;
    }

    private boolean isValidJcrPath(String absPath) {
        try {
            String pathToValidate = absPath;
            String txId = TransactionServiceImpl.getCurrentTransactionId((Session)this.session);
            if (!this.canonical && txId != null) {
                String txIdWithSlash = "/tx:" + txId;
                pathToValidate = StringUtils.replaceOnce((String)absPath, (String)txIdWithSlash, (String)"");
                LOGGER.debug("removed {} from URI {}. Path for JCR validation is now: {}", new Object[]{txIdWithSlash, absPath, pathToValidate});
            }
            this.session.getValueFactory().createValue(pathToValidate, 8);
            return true;
        }
        catch (ValueFormatException e) {
            LOGGER.trace("Unable to validate JCR path: ", (Throwable)e);
            return false;
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException("Unable to validate JCR path: ", (Throwable)e);
        }
    }

    public boolean isFedoraGraphSubject(Resource subject) {
        return subject.isURIResource() && this.isFedoraGraphSubject(subject.getURI());
    }

    private boolean isFedoraGraphSubject(String subjectUri) {
        return subjectUri.startsWith(this.basePath) && this.isValidJcrPath(subjectUri.substring(this.pathIx));
    }

    private Map<String, String> getPathMap(String absPath) {
        String path = absPath.substring(1);
        if (this.session != null) {
            Workspace workspace = this.session.getWorkspace();
            String txId = TransactionServiceImpl.getCurrentTransactionId((Session)this.session);
            if (!this.canonical && txId != null) {
                path = TX_PREFIX + txId + "/" + path;
            } else if (workspace != null && !workspace.getName().equals(this.defaultWorkspace)) {
                path = WORKSPACE_PREFIX + workspace.getName() + "/" + path;
            }
        }
        return Collections.singletonMap("path", path);
    }

    protected Resource doRdfForward(String inputId) {
        URI result = this.uriBuilder.buildFromMap(this.getPathMap(inputId));
        return ResourceFactory.createResource((String)result.toString());
    }

    protected String doRdfBackward(Resource subject) {
        String subjectUri = HttpIdentifierTranslator.getResourceURI(subject);
        if (subjectUri == null) {
            return null;
        }
        try {
            return this.getPathFromGraphSubject(subjectUri);
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected void resetTranslationChain() {
        if (this.translationChain == null) {
            if (this.getTranslationChain() != null) {
                this.setTranslationChain(this.getTranslationChain());
            } else {
                this.setTranslationChain(minimalTranslationChain);
            }
        }
    }

    public String getBaseUri() {
        return this.uris.getBaseUri().toString();
    }
}

