/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.util.concurrent.AbstractFuture;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.util.Literals;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriterRegistry;
import org.openrdf.rio.Rio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfStreamStreamingOutput
extends AbstractFuture<Void>
implements StreamingOutput {
    private static final Logger LOGGER = LoggerFactory.getLogger(RdfStreamStreamingOutput.class);
    private static ValueFactory vfactory = ValueFactoryImpl.getInstance();
    private final RDFFormat format;
    private final RdfStream rdfStream;
    private static final Void finishedMarker = null;
    protected static final Function<? super Triple, Statement> toStatement = new Function<Triple, Statement>(){

        public Statement apply(Triple t) {
            Value object = RdfStreamStreamingOutput.getValueForObject(t.getObject());
            return vfactory.createStatement((Resource)vfactory.createURI(t.getSubject().getURI()), vfactory.createURI(t.getPredicate().getURI()), object);
        }
    };

    public RdfStreamStreamingOutput(RdfStream rdfStream, MediaType mediaType) {
        RDFFormat format;
        if (LOGGER.isDebugEnabled()) {
            for (RDFFormat writeableFormats : RDFWriterRegistry.getInstance().getKeys()) {
                LOGGER.debug("Discovered RDF writer writeableFormats: {} with mimeTypes: {}", (Object)writeableFormats.getName(), (Object)Joiner.on((String)" ").join((Iterable)writeableFormats.getMIMETypes()));
            }
        }
        if ((format = Rio.getWriterFormatForMIMEType((String)mediaType.toString())) == null) {
            throw new WebApplicationException(Response.Status.NOT_ACCEPTABLE);
        }
        this.format = format;
        LOGGER.debug("Setting up to serialize to: {}", (Object)format);
        this.rdfStream = rdfStream;
    }

    public void write(OutputStream output) throws IOException {
        LOGGER.debug("Serializing RDF stream in: {}", (Object)this.format);
        try {
            Rio.write(this.asStatements(), (OutputStream)output, (RDFFormat)this.format);
            this.set(finishedMarker);
        }
        catch (RDFHandlerException e) {
            this.setException(e);
            LOGGER.debug("Error serializing RDF", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    private Iterable<Statement> asStatements() {
        return new Iterable<Statement>(){

            @Override
            public Iterator<Statement> iterator() {
                return RdfStreamStreamingOutput.this.rdfStream.transform(toStatement);
            }
        };
    }

    protected static Value getValueForObject(Node object) {
        if (object.isURI()) {
            return vfactory.createURI(object.getURI());
        }
        if (object.isLiteral()) {
            return Literals.createLiteral((ValueFactory)vfactory, (Object)object.getLiteralValue());
        }
        throw new UnsupportedOperationException("We do not serialize blank nodes!");
    }
}

