/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.session;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.security.Principal;
import javax.annotation.PostConstruct;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.fcrepo.kernel.Transaction;
import org.fcrepo.kernel.impl.LockReleasingSession;
import org.fcrepo.kernel.services.TransactionService;
import org.modeshape.jcr.api.ServletCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SessionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionFactory.class);
    @Autowired
    private Repository repo;
    @Autowired
    private TransactionService transactionService;

    public SessionFactory() {
    }

    public SessionFactory(Repository repo, TransactionService transactionService) {
        this.repo = repo;
        this.transactionService = transactionService;
    }

    @PostConstruct
    public void init() {
        Preconditions.checkNotNull((Object)this.repo, (Object)"SessionFactory requires a Repository instance!");
    }

    public Session getInternalSession() throws RepositoryException {
        return this.repo.login();
    }

    public Session getInternalSession(String workspace) throws RepositoryException {
        return this.repo.login(workspace);
    }

    public Session getSession(HttpServletRequest servletRequest) {
        try {
            String txId = this.getEmbeddedId(servletRequest, Prefix.TX);
            Session session = txId == null ? this.createSession(servletRequest) : this.getSessionFromTransaction(servletRequest, txId);
            String lockToken = servletRequest.getHeader("Lock-Token");
            if (lockToken != null) {
                session.getWorkspace().getLockManager().addLockToken(lockToken);
            }
            return LockReleasingSession.newInstance((Session)session);
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected Session createSession(HttpServletRequest servletRequest) throws RepositoryException {
        Session session;
        ServletCredentials creds = new ServletCredentials(servletRequest);
        String workspace = this.getEmbeddedId(servletRequest, Prefix.WORKSPACE);
        if (workspace != null) {
            LOGGER.debug("Returning an authenticated session in the workspace {}", (Object)workspace);
            session = this.repo.login((Credentials)creds, workspace);
        } else {
            LOGGER.debug("Returning an authenticated session in the default workspace");
            session = this.repo.login((Credentials)creds);
        }
        return session;
    }

    protected Session getSessionFromTransaction(HttpServletRequest servletRequest, String txId) throws RepositoryException {
        Principal userPrincipal = servletRequest.getUserPrincipal();
        String userName = null;
        if (userPrincipal != null) {
            userName = userPrincipal.getName();
        }
        Transaction transaction = this.transactionService.getTransaction(txId, userName);
        LOGGER.debug("Returning a session in the transaction {} for user {}", (Object)transaction, (Object)userName);
        return transaction.getSession();
    }

    protected String getEmbeddedId(HttpServletRequest servletRequest, Prefix prefix) {
        String requestPath = servletRequest.getPathInfo();
        String id = null;
        if (requestPath != null) {
            String pathPrefix = prefix.getPrefix();
            String[] part = requestPath.split("/");
            if (part.length > 1 && part[1].startsWith(pathPrefix)) {
                id = part[1].substring(pathPrefix.length());
            }
        }
        return id;
    }

    protected static enum Prefix {
        WORKSPACE("workspace:"),
        TX("tx:");

        private final String prefix;

        private Prefix(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

